#include "LocalControl.h"

#include "tools.h"

string LocalConsole::GetUpdatePrompt() const
{
    const string beg = GetLinePrompt();

    // Compile a string like "server:state> "
    const string end =
        Form("\033[34m\033[1m%s\033[0m:\033[32m\033[1m%s\033[0m> ",
             fName.c_str(), fStateMachine->GetStateName().c_str());

    // If we are continously flushing the buffer omit the buffer size
    // If we are buffering show the buffer size
    return "\n" + beg + " " + end;
}

//#include <boost/regex.hpp>

string LocalShell::GetUpdatePrompt() const
{
    //const string s = (beg[0]=='\n'?beg.substr(1):beg) + " " + end;
    //return boost::regex_replace(s, boost::regex("\033[[0-9]+m"), "");

    const string beg = GetLinePrompt();

    const string end =
        Form("%s:%s> ", fName.c_str(),
             fStateMachine->GetStateName().c_str());

    return beg + " " + end;
}
