#ifndef FACT_Console
#define FACT_Console

#include "Readline.h"
#include "WindowLog.h"

class Console : public Readline
{
private:
    WindowLog fLogO;
    WindowLog fLogI;

    bool fContinous;
public:
    Console(const char *name);
    ~Console();

    void SetContinous(bool cont) { fContinous = cont; }
    bool IsContinous() const { return fContinous; }

    WindowLog &GetStreamOut() { return fLogO; }
    WindowLog &GetStreamIn()  { return fLogI; }

    const WindowLog &GetStreamOut() const { return fLogO; }
    const WindowLog &GetStreamIn()  const { return fLogI; }

    std::string GetLinePrompt() const;

    void Startup();
    void EventHook();
    //void Shutdown(const char * =0);
    void Run(const char * = 0);
};

#endif
