// **************************************************************************
/** @class DimErrorRedirecter

*/
// **************************************************************************
#include "DimErrorRedirecter.h"

#include <dic.hxx>

#include "WindowLog.h"
#include "MessageImp.h"

using namespace std;

int DimErrorRedirecter::cnt = 0;

DimErrorRedirecter::DimErrorRedirecter(MessageImp &imp) : fMsg(imp)
{
    if (cnt++)
    {
        fMsg.Error("ERROR - More than one instance of MyHandlers.");
        exit(-1);
    }

    DimClient::addErrorHandler(this);
}

void DimErrorRedirecter::errorHandler(int severity, int code, char *msg)
{
    switch (severity)
    {
    case DIM_FATAL:   fMsg.Error(msg); return;
    case DIM_ERROR:   fMsg.Error(msg); return;
    case DIM_WARNING: fMsg.Warn(msg);  return;
    case DIM_INFO:    fMsg.Info(msg);  return;
    }

    stringstream str;
    str << "Severity of Dim message unknown(" << severity << "): ";
    str << msg << "(" << code << ")";
    fMsg.Message(str);

    /*
     DIMDNSUNDEF	DIM_FATAL	DIM_DNS_NODE undefined
     DIMDNSREFUS	DIM_FATAL	DIM_DNS refuses connection
     DIMDNSDUPLC	DIM_FATAL	Service already exists in DNS
     DIMDNSEXIT	        DIM_FATAL	DNS requests server to EXIT
     DIMDNSTMOUT	DIM_WARNING	Server failed sending Watchdog

     DIMDNSCNERR	DIM_ERROR	Connection to DNS failed
     DIMDNSCNEST	DIM_INFO	Connection to DNS established

     DIMSVCDUPLC	DIM_ERROR	Service already exists in Server
     DIMSVCFORMT	DIM_ERROR	Bad format string for service
     DIMSVCINVAL	DIM_ERROR	Invalid Service ID

     DIMTCPRDERR	DIM_ERROR	TCP/IP read error
     DIMTCPWRRTY	DIM_WARNING	TCP/IP write error - Retrying
     DIMTCPWRTMO	DIM_ERROR	TCP/IP write error - Disconnected
     DIMTCPLNERR	DIM_ERROR	TCP/IP listen error
     DIMTCPOPERR	DIM_ERROR	TCP/IP open server error
     DIMTCPCNERR	DIM_ERROR	TCP/IP connection error
     DIMTCPCNEST	DIM_INFO	TCP/IP connection established
     */
}

