#ifndef FACT_MessageImp
#define FACT_MessageImp

#include <string>
#include <sstream>
#include <iostream>

class Time;

class MessageImp
{
public:
    /// Severity of a message
    enum Severity
    {
        kMessage = 10, ///< Just a message, usually obsolete
        kInfo    = 20, ///< An info telling something which can be interesting to know
        kWarn    = 30, ///< A warning, things that somehow might result in unexpected or unwanted bahaviour
        kError   = 40, ///< Error, something unexpected happened, but can still be handled by the program
        kFatal   = 50, ///< An error which cannot be handled at all happend, the only solution is program termination
        kDebug   = 99, ///< A message used for debugging only
    };

private:
    std::ostream &fOut; /// The ostream to which by default Write redirects its output

public:
    MessageImp(std::ostream &out=std::cout);

    virtual int Write(const Time &time, const char *txt, int qos=kInfo);

    int Update(const char *txt, int qos=kInfo);
    int Update(const std::string &str, int qos=kInfo) { return Update(str.c_str(), qos); }
    int Update(const std::stringstream &str, int qos=kInfo) { return Update(str.str(), qos); }
    int Update(int qos, const char *fmt, ...);

    int Debug(const char *txt)   { return Update(txt, kDebug); }
    int Message(const char *txt) { return Update(txt, kMessage); }
    int Info(const char *txt)    { return Update(txt, kInfo);    }
    int Warn(const char *txt)    { return Update(txt, kWarn);    }
    int Error(const char *txt)   { return Update(txt, kError);   }
    int Fatal(const char *txt)   { return Update(txt, kFatal);   }

    int Debug(const std::string &str)   { return Debug(str.c_str()); }
    int Message(const std::string &str) { return Message(str.c_str()); }
    int Info(const std::string &str)    { return Info(str.c_str());    }
    int Warn(const std::string &str)    { return Warn(str.c_str());    }
    int Error(const std::string &str)   { return Error(str.c_str());   }
    int Fatal(const std::string &str)   { return Fatal(str.c_str());   }

    int Debug(const std::stringstream &str)   { return Debug(str.str()); }
    int Message(const std::stringstream &str) { return Message(str.str()); }
    int Info(const std::stringstream &str)    { return Info(str.str());    }
    int Warn(const std::stringstream &str)    { return Warn(str.str());    }
    int Error(const std::stringstream &str)   { return Error(str.str());   }
    int Fatal(const std::stringstream &str)   { return Fatal(str.str());   }

    std::ostream &operator()() const { return fOut; }
    std::ostream &Out() const { return fOut; }
};

#endif
