#ifndef FACT_Console
#define FACT_Console

#include "Readline.h"
#include "WindowLog.h"

class ConsoleStream : public Readline
{
private:
    WindowLog fLogO;

public:
    ConsoleStream(const char *name);

    // I/O
    WindowLog &GetStreamOut() { return fLogO; }
    WindowLog &GetStreamIn()  { return fLogO; }

    const WindowLog &GetStreamOut() const { return fLogO; }
    const WindowLog &GetStreamIn()  const { return fLogO; }

    void Run(const char * = 0);
};



class Console : public Readline
{
private:
    WindowLog fLogO;
    WindowLog fLogI;

    bool fContinous;
public:
    Console(const char *name);
    ~Console();

    // Console
    void SetContinous(bool cont) { fContinous = cont; }
    bool IsContinous() const { return fContinous; }

    // I/O
    WindowLog &GetStreamOut() { return fLogO; }
    WindowLog &GetStreamIn()  { return fLogI; }

    const WindowLog &GetStreamOut() const { return fLogO; }
    const WindowLog &GetStreamIn()  const { return fLogI; }

    // Readline
    bool PrintGeneralHelp();
    bool PrintCommands();
    bool PrintKeyBindings();

    bool Process(const std::string &str);

    std::string GetLinePrompt() const;

    void Startup();
    void EventHook();
    void Run(const char * = 0);
};

#endif
