#include "FactGui.h"

#include "src/FACT.h"
#include "src/Dim.h"
#include "src/Configuration.h"

/*
 Extract usage clause(s) [if any] for SYNOPSIS.
 Translators: "Usage" and "or" here are patterns (regular expressions) which
 are used to match the usage synopsis in program output.  An example from cp
 (GNU coreutils) which contains both strings:
  Usage: cp [OPTION]... [-T] SOURCE DEST
    or:  cp [OPTION]... SOURCE... DIRECTORY
    or:  cp [OPTION]... -t DIRECTORY SOURCE...
 */
void PrintUsage()
{
    cout << "\n"
        "The FACT++ Graphical User Interfact (GUI).\n"
        "\n"
        "Usage: fact [-c type] [OPTIONS]\n"
        "  or:  fact [OPTIONS]\n";
    cout << endl;

}

void PrintHelp()
{
    /* Additional help text which is printed after the configuration
     options goes here */
}

void SetupConfiguration(Configuration &conf)
{
    po::options_description config("Program options");
    config.add_options()
        ("dns",  var<string>("localhost"), "Dim nameserver (overwites DIM_DNS_NODE environment variable)")
        ("host", var<string>(""),          "Address with which the Dim nameserver can connect to this host (overwites DIM_HOST_NODE environment variable)")
        ;

    conf.AddEnv("dns", "DIM_DNS_NODE");
    conf.AddEnv("dns", "DIM_HOST_NODE");

    conf.AddOptions(config);
}

int main(int argc, const char* argv[])
{
    Configuration conf(argv[0]);
    conf.SetPrintUsage(PrintUsage);
    SetupConfiguration(conf);

    if (!conf.DoParse(argc, argv, PrintHelp))
        return -1;

    Dim::Setup(conf.Get<string>("dns"), conf.Get<string>("host"));

    QApplication app(argc, const_cast<char**>(argv));

    FactGui gui;
    gui.show();

    const int rc = app.exec();

    cout << "The end." << endl;

    return rc;
}
