#ifndef Q_CAMERA_WIDGET_H_
#define Q_CAMERA_WIDGET_H_

#include "BasicGlCamera.h"
#include <valarray>

using namespace std;

class QCameraWidget : public BasicGlCamera
{
    Q_OBJECT

    typedef pair<double, double> Position;
    typedef vector<Position> Positions;

    Positions fGeom;

    vector<bool> fBold;
    vector<bool> fEnable;

    int fWhite;

    int64_t fMin;
    int64_t fMax;

public:
    QCameraWidget(QWidget *pparent = 0);
    void paintGL();
    void mousePressEvent(QMouseEvent *cEvent);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseDoubleClickEvent(QMouseEvent *event);
    void Reset();
    void drawCamera(bool alsoWire);
     void SetBold(int idx);
     void SetWhite(int idx);
     void SetEnable(int idx, bool b);
     void Toggle(int idx);
     double GetData(int idx);
     void SetMin(int64_t min);
     void SetMax(int64_t max);
     const char *GetName();

     int GetIdx(float px, float py);
     char *GetObjectInfo(int px, int py);

     void SetData(const valarray<double> &ddata);

Q_SIGNALS:
         void signalCurrentPixel(int pixel);
         void signalPixelMoveOver(int pixel);
         void signalPixelDoubleClick(int pixel);

private:
     void CalculatePixelsColor();
};

typedef QCameraWidget Camera;
#endif
