/*
 * QtGl.cpp
 *
 *  Created on: Jul 19, 2011
 *      Author: lyard
 */
//FIXME replace with FACT++ Time class
#include <boost/date_time/local_time/local_time.hpp>


#include "RawEventsViewer.h"
#include "viewer.h"
#include <math.h>
#include <fstream>

#ifdef LOAD_RAW
int16_t eventsData[NUM_STORED_EVENTS][ACTUAL_NUM_PIXELS][1024];
#include </home/lyard/Code/display.C>
#endif

#define VALUES_SPAN 4096

#include <QFileDialog>

#include <qwt_symbol.h>

#include "src/Configuration.h"
#include "externals/fits.h"


using namespace std;

#undef ACTUAL_NUM_PIXELS
#define ACTUAL_NUM_PIXELS 1440

//bounding box for diplaying the impulse curve
float bboxMin[2] = {-0.8,-0.9};
float bboxMax[2] = {0.8,-0.3};
/************************************************************
 * CALC BLUR COLOR if in blur display mode, calculate the interpolated
 * colour for a given vertex
 ************************************************************/
void RawDataViewer::calcBlurColor(int pixel,  int vertex)
{
    GLfloat color[3];
    int first, second;
    first = vertex-1;
    second = vertex;
    if (first < 0)
        first = 5;
    first = neighbors[pixel][first];
    second = neighbors[pixel][second];
    for (int i=0;i<3;i++)
        color[i] = pixelsColor[pixel][i];
    float divide = 1;
    if (first != -1)
    {
        divide++;
        for (int i=0;i<3;i++)
            color[i] += pixelsColor[first][i];
    }
    if (second != -1)
    {
        divide++;
        for (int i=0;i<3;i++)
            color[i] += pixelsColor[second][i];
    }
    for (int i=0;i<3;i++)
        color[i] /= divide;
    glColor3fv(color);
}
/************************************************************
 * DRAW BLURRY HEXAGON. draws a solid hexagon, with interpolated colours
 ************************************************************/
void RawDataViewer::drawBlurryHexagon(int index)
{
    GLfloat color[3];
    for (int i=0;i<3;i++)
        color[i] = pixelsColor[index][i];
    glBegin(GL_TRIANGLES);
    calcBlurColor(index, 0);
    glVertex2fv(verticesList[verticesIndices[index][0]]);
    glColor3fv(color);
    glVertex2fv(pixelsCoords[index]);
    calcBlurColor(index, 1);
    glVertex2fv(verticesList[verticesIndices[index][1]]);

    glVertex2fv(verticesList[verticesIndices[index][1]]);
    glColor3fv(color);
    glVertex2fv(pixelsCoords[index]);
    calcBlurColor(index, 2);
    glVertex2fv(verticesList[verticesIndices[index][2]]);

    glVertex2fv(verticesList[verticesIndices[index][2]]);
    glColor3fv(color);
    glVertex2fv(pixelsCoords[index]);
    calcBlurColor(index, 3);
    glVertex2fv(verticesList[verticesIndices[index][3]]);

    glVertex2fv(verticesList[verticesIndices[index][3]]);
    glColor3fv(color);
    glVertex2fv(pixelsCoords[index]);
    calcBlurColor(index, 4);
    glVertex2fv(verticesList[verticesIndices[index][4]]);

    glVertex2fv(verticesList[verticesIndices[index][4]]);
    glColor3fv(color);
    glVertex2fv(pixelsCoords[index]);
    calcBlurColor(index, 5);
    glVertex2fv(verticesList[verticesIndices[index][5]]);

    glVertex2fv(verticesList[verticesIndices[index][5]]);
    glColor3fv(color);
    glVertex2fv(pixelsCoords[index]);
    calcBlurColor(index, 0);
    glVertex2fv(verticesList[verticesIndices[index][0]]);
    glEnd();

    return;
}

/************************************************************
 * DRAW CAMERA draws all the camera pixels
 ************************************************************/
void RawDataViewer::drawCamera(bool alsoWire)
{
    glLoadIdentity();
    if (!drawImpulse)
    {
        glTranslatef(0,-0.44,0);
        glRotatef(cameraRotation, 0,0,-1);
        if (cameraRotation == 90)
        {
            glTranslatef(-0.45,-0.45,0);
 //           cout << "correction" << endl;
        }
        if (cameraRotation == -90)
        {
            glTranslatef(0.45,-0.45,0);
        }
        glScalef(1.5,1.5,1);
    }
    else
    {
        glRotatef(cameraRotation, 0,0,-1);
          if (cameraRotation == 90)
        {
            glTranslatef(-0.45/1.5,-0.45/1.5,0);
 //           cout << "correction" << endl;
        }
        if (cameraRotation == -90)
        {
            glTranslatef(0.45/1.5,-0.45/1.5,0);
        }
  }
    glColor3f(0.5,0.5,0.5);
    glLineWidth(1.0);
    float color;
//cout << "Actual num pixels: " << ACTUAL_NUM_PIXELS << endl;
    for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
    {
        if (!nRoi)
          color = (float)(i)/(float)(ACTUAL_NUM_PIXELS);
        else
#ifdef LOAD_RAW
        color = float(eventsData[eventNum][i][whichSlice]+(VALUES_SPAN/2))/(float)(VALUES_SPAN-1);
#else
        color = float(eventData[nRoi*hardwareMapping[i] + whichSlice]+(VALUES_SPAN/2))/(float)(VALUES_SPAN-1);
        if (logScale)
        {
            color *= 9;
            color += 1;
            color = log10(color);
        }
#endif
        if (color < 0)
        {
            pixelsColor[i][0] = tooLowValueCoulour[0];
            pixelsColor[i][1] = tooLowValueCoulour[1];
            pixelsColor[i][2] = tooLowValueCoulour[2];
            continue;
        }
        if (color > 1)
        {
            pixelsColor[i][0] = tooHighValueCoulour[0];
            pixelsColor[i][1] = tooHighValueCoulour[1];
            pixelsColor[i][2] = tooHighValueCoulour[2];
            continue;
        }
        int index = 0;
        while (ss[index] < color && index < 4)
            index++;
        index--;
        if (index < 0) index = 0;
        float weight0 = (color-ss[index]) / (ss[index+1]-ss[index]);
        if (weight0 > 1.0f) weight0 = 1.0f;
        if (weight0 < 0.0f) weight0 = 0.0f;
        float weight1 = 1.0f-weight0;
        pixelsColor[i][0] = weight1*rr[index] + weight0*rr[index+1];
        pixelsColor[i][1] = weight1*gg[index] + weight0*gg[index+1];
        pixelsColor[i][2] = weight1*bb[index] + weight0*bb[index+1];
    }

    for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
    {
//        if (i == 690 ||
//            i == 70)
//            continue;
        glColor3fv(pixelsColor[i]);
        glLoadName(i);
if (drawBlur)
    drawBlurryHexagon(i);
else
    drawHexagon(i,true);

    }
    if (!alsoWire)
        return;
    glTranslatef(0,0,0.1f);
    glColor3f(0.0f,0.0f,0.0f);
    for (int i=0;i<ACTUAL_NUM_PIXELS;i++)
    {
//        if (i == 690 ||
//            i == 70)
//            continue;
        drawHexagon(i, false);
    }

}

/************************************************************
 * TRIM. FIXME this should not be here but taken from an existing class (somewhere)
 ***********************************************************
string Trim(const string &str)
{
    // Trim Both leading and trailing spaces
    const size_t start = str.find_first_not_of(' '); // Find the first character position after excluding leading blank spaces
    const size_t end   = str.find_last_not_of(' ');  // Find the first character position from reverse af

    // if all spaces or empty return an empty string
    if (string::npos==start || string::npos==end)
        return string();

    return str.substr(start, end-start+1);
}*/
/************************************************************
 * DRAW PIXEL CURVE. draws the raw impulse curve of the currently selected pixel
 ************************************************************/
void RawDataViewer::drawPixelCurve()
{
    if (!nRoi)
        return;

    float xZoom, yZoom;
    xZoom = yZoom = 1.0f;

    glBegin(GL_LINES);
    glLineWidth(1.0f);
    glColor3f(0.5,0.5,0.5);
    glVertex2f(bboxMin[0], bboxMin[1]);
    glVertex2f(bboxMax[0], bboxMin[1]);
    glVertex2f(bboxMin[0], bboxMin[1]);
    glVertex2f(bboxMin[0], bboxMax[1]);
    glVertex2f(bboxMin[0], (bboxMin[1]+bboxMax[1])/2.0f);
    glVertex2f(bboxMax[0], (bboxMin[1]+bboxMax[1])/2.0f);
    float xRange = bboxMax[0] - bboxMin[0];
    float yRange = bboxMax[1] - bboxMin[1];
    glColor3f(1.0,1.0,1.0);
    float divideMe = (float)(VALUES_SPAN-1);
    float plusMe = VALUES_SPAN/2;

    /*
    if (drawCalibrationLoaded)
        plusMe += 0;//VALUES_SPAN/2;
    if (drawCalibrationLoaded && calibrationLoaded)
    {
        divideMe /=2;
        plusMe = 0 ;///=2;
        }*/

    const int hw = hardwareMapping[selectedPixel];

    for (int i=0;i<nRoi-1;i++)
    {
#ifdef LOAD_RAW
        glVertex2f(bboxMin[0] + xRange*i/(float)nRoi,
                   bboxMin[1] + yRange*(eventsData[eventNum][selectedPixel][i]+plusMe) /divideMe);
        glVertex2f(bboxMin[0] + xRange*(i+1)/(float)nRoi,
                   bboxMin[1] + yRange*(eventsData[eventNum][selectedPixel][i+1]+plusMe) /divideMe);
#else


        float d1 = eventData[nRoi*hw + i]+plusMe;
        float d2 = eventData[nRoi*hw + i+1]+plusMe;
        if (!finite(d1)) d1 = 20000;
        if (!finite(d2)) d2 = 20000;
        glVertex2f(bboxMin[0] + xRange*i/(float)nRoi,
                   bboxMin[1] + yRange*(d1) /divideMe);
        glVertex2f(bboxMin[0] + xRange*(i+1)/(float)nRoi,
                   bboxMin[1] + yRange*(d2) /divideMe);
#endif
    }
    glEnd();
    glTranslatef(0,0,0.1f);
    glBegin(GL_LINES);
    glColor3f(1.0,0.0,0.0);
    glVertex2f(bboxMin[0] + xRange*whichSlice/(float)nRoi,
               bboxMin[1]);
    glVertex2f(bboxMin[0] + xRange*whichSlice/(float)nRoi,
               bboxMax[1]);

/*    glColor3f(0.f,0.5f,0.f);
    for (int i=0;i<nRoi-1;i++)
    {
        glVertex2f(bboxMin[0] + xRange*i/(float)nRoi,
                   bboxMin[1] + yRange*(n1mean[ i]+plusMe) /divideMe);
        glVertex2f(bboxMin[0] + xRange*(i+1)/(float)nRoi,
                   bboxMin[1] + yRange*(n1mean[i+1]+plusMe) /divideMe);
    }
*/
    glEnd();
 //   glEnable(GL_MULTISAMPLE);
 /*   setFont(QFont("Times", 12));
    qglColor(QColor(255,223,127));
    float xShift = 0.10f;
    float yShift = 0.01f;
    renderText(bboxMin[0]-xShift/2.0f, bboxMax[1]+3*yShift, 0, QString("Volts"));
    if (drawCalibrationLoaded)
    {
        renderText(bboxMin[0]-xShift, bboxMax[1]-yShift,0,QString("+2.10"));
        renderText(bboxMin[0]-xShift,  ((bboxMin[1]+bboxMax[1])/2.0f) - yShift, 0, QString("+1.05"));//((bboxMin[1]+bboxMax[1])/2.0f)
        renderText(bboxMin[0]-xShift, bboxMin[1]-yShift, 0, QString("0.00"));
    }
    else
    {
        renderText(bboxMin[0]-xShift, bboxMax[1]-yShift,0,QString("+1.05"));
        renderText(bboxMin[0]-xShift,  ((bboxMin[1]+bboxMax[1])/2.0f) - yShift, 0, QString("+0.00"));//((bboxMin[1]+bboxMax[1])/2.0f)
        renderText(bboxMin[0]-xShift, bboxMin[1]-yShift, 0, QString("-1.05"));
    }
    renderText(bboxMax[0]+xShift/2.0f, bboxMin[1]-4*yShift, 0, QString("Slices"));
    renderText(bboxMin[0]-yShift/2.0f, bboxMin[1]-4*yShift, 0, QString("0"));
    ostringstream str;
    str << nRoi/2;
    renderText(((bboxMin[0]+bboxMax[0])/2.0f)-xShift/2.0f, bboxMin[1]-4*yShift, 0, QString(str.str().c_str()));
    str.str("");
    str << nRoi;
    renderText(bboxMax[0]-xShift/2.0f, bboxMin[1]-4*yShift, 0, QString(str.str().c_str()));
*/
}
/************************************************************
 * CONSTRUCTOR.
 ************************************************************/
RawDataViewer::RawDataViewer(QWidget *cParent) : BasicGlCamera(cParent), RMSvalues(1440)
{
 //   setFormat(QGLFormat(QGL::DoubleBuffer));// | QGL::DepthBuffer));
    whichSlice = 0;
#ifdef LOAD_RAW
    nRoi = 1024;
#else
    nRoi = 0;
#endif
    eventNum = 0;
    rowNum = -1;
    eventStep = 1;
    selectedPixel = 393;
    inputFile = NULL;
    eventData = NULL;
    drawPatch = true;
    drawImpulse = true;
    drawBlur = false;
    loopCurrentEvent = false;
    SetAutoRefresh(true);
#ifdef LOAD_RAW
    loadEvents("/scratch/00000043.001_T.bin");
#endif
    PixelMap mypMap;
    if (!mypMap.Read("FACTmapV5a.txt"))
    {
        cerr << "ERROR - Problems reading FACTmapV5a.txt" << endl;
        exit(-1);
    }

    assignPixelMap(mypMap);
    buildVerticesList();

    for (int i=0;i<160;i++)
    {
        const float color[3] = { 0.5, 0.5, 0.3 };

        for (int j=0;j<3;j++)
            patchesColor[i][j] = color[j];
    }

    //calibrationLoaded = false;
    //drawCalibrationLoaded = false;

}
/************************************************************
 *  DESTRUCTOR
 ************************************************************/
RawDataViewer::~RawDataViewer()
{
    if (inputFile != NULL)
    {
        inputFile->close();
        delete inputFile;
    }
    if (eventData != NULL) {
        delete[] eventData;
        delete[] rawEventData;
        delete[] waveLetArray;
    }
}

/************************************************************
 * PAINT GL. main drawing function.
 ************************************************************/
void RawDataViewer::paintGL()
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glLoadIdentity();

    glTranslatef(0,0,-0.5);

    if (drawBlur)
    {
        glShadeModel(GL_SMOOTH);
        drawCamera(false);
    }
    else
    {
        glShadeModel(GL_FLAT);
        drawCamera(true);
    }
    glTranslatef(0,0,0.1f);
    if (drawPatch)
        drawPatches();
    glTranslatef(0,0,0.1f);
   if (!drawBlur)
   {
        glLineWidth(1.0f);
        glColor3f(1.0,1.0,1.0);
        drawHexagon(selectedPixel, false);
   }
   glTranslatef(0,0,0.1f);
   if (drawImpulse)
   {
    //   glRotatef(cameraRotation, 0,0,1);
       glLoadIdentity();
       glLineWidth(2.0);
       drawPixelCurve();
   }
   glTranslatef(0,0,0.1f);
   DrawScale();
}

/************************************************************
 * MOUSE PRESS EVENT. mouse click handler.
 ************************************************************/
void RawDataViewer::mousePressEvent(QMouseEvent *cEvent)
{
    if (cEvent->pos().x() > width()-(width()/50.f))
    {
        toggleInterfaceDisplay();
        return;
    }
    lastPos = cEvent->pos();
    setCorrectSlice(cEvent);
    int face = PixelAtPosition(cEvent->pos());
    if (face != -1) {
        selectedPixel = face;
        emit signalCurrentPixel(face);
        }
    updateGL();
}

/************************************************************
 * SET CORRECT SLICE. if displayed, figures out if the graph was
 * clicked, and if so, which slice should be displayed
 ************************************************************/
void RawDataViewer::setCorrectSlice(QMouseEvent* cEvent)
{
    if (!drawImpulse)
        return;
    float cx = (float)cEvent->x() * pixelSize - shownSizex/2;
    float cy = ((float)height()-(float)cEvent->y())*pixelSize - shownSizey/2;
    if (cx < bboxMin[0] ||
        cx > bboxMax[0] ||
        cy < bboxMin[1] ||
        cy > bboxMax[1])
        return;
    whichSlice = (cx - bboxMin[0])*1024/(bboxMax[0] - bboxMin[0]);
    emit signalCurrentSlice(whichSlice);
}

/************************************************************
 * MOUSE MOVE EVENT. used to track the dragging of slices display
 ************************************************************/
void RawDataViewer::mouseMoveEvent(QMouseEvent *cEvent)
{
    if (cEvent->buttons() & Qt::LeftButton) {
        setCorrectSlice(cEvent);
        updateGL();
    } else if (cEvent->buttons() & Qt::RightButton) {
        updateGL();
    }
    lastPos = cEvent->pos();
}

/************************************************************
 * MOUSE DOUBLE CLICK EVENT. used to select pixels
 ************************************************************/
void RawDataViewer::mouseDoubleClickEvent(QMouseEvent *cEvent)
{
    int face = PixelAtPosition(cEvent->pos());
    if (face != -1) {
        selectedPixel = face;
        emit signalCurrentPixel(face);
        updateGL();
        }
}

/************************************************************
 * OPEN FILE. opens a new fits file
 ************************************************************/
void RawDataViewer::openFile(string& file)
{
    if (inputFile)
    {
        inputFile->close();
        delete inputFile;
    }
    try {
    inputFile = new fits(file);
    }
    catch (std::runtime_error e)
    {
        cout << "Something went wrong while loading fits. aborting: " << e.what() << endl;
        return;
    }
    if (!*inputFile)
    {
        delete inputFile;
        inputFile = NULL;
        return;
    }
    vector<string> entriesToCheck;
    entriesToCheck.push_back("NAXIS2");
    entriesToCheck.push_back("NROI");
    entriesToCheck.push_back("REVISION");
    entriesToCheck.push_back("RUNID");
    entriesToCheck.push_back("NBOARD");
    entriesToCheck.push_back("NPIX");
    entriesToCheck.push_back("NROITM");
    entriesToCheck.push_back("TIMESYS");
    entriesToCheck.push_back("DATE");
    entriesToCheck.push_back("NIGHT");
    entriesToCheck.push_back("CAMERA");
    entriesToCheck.push_back("DAQ");
    entriesToCheck.push_back("TSTART");
    entriesToCheck.push_back("TSTOP");
    //entriesToCheck.push_back("ADCRANGE");
    //entriesToCheck.push_back("NBEVTOK");
    //entriesToCheck.push_back("NBEVTREJ");
    //entriesToCheck.push_back("NBEVTBAD");

    for (vector<string>::const_iterator it=entriesToCheck.begin(); it != entriesToCheck.end(); it++)
    {
        try {
        if (!inputFile->HasKey(*it)){
            cout << *it << " missing. Aborting load..." << endl;
            return;}
        }
        catch (std::runtime_error e)
        {
            cout << e.what() << endl;
            return;
        }
    }
    nRows = inputFile->GetInt("NAXIS2");
    nRoi = inputFile->GetInt("NROI");
    runNumber = inputFile->GetInt("RUNID");
    nTM = inputFile->HasKey("NTMARK") ? inputFile->GetInt("NTMARK") : 0;
    runType = inputFile->HasKey("RUNTYPE") ? inputFile->GetInt("RUNTYPE") : -1;
    firstDataTime = inputFile->GetInt("TSTART");
    lastDataTime = inputFile->GetInt("TSTOP");
    nRoiTM = inputFile->GetInt("NROITM");
    revision = inputFile->GetInt("REVISION");
    builderVersion = inputFile->HasKey("BLDVER") ? inputFile->GetInt("BLDVER") : -1;
    nBoards = inputFile->GetInt("NBOARD");
    nPixels = inputFile->GetInt("NPIX");
    timeSystem = inputFile->GetStr("TIMESYS");
    creationDate = inputFile->GetStr("DATE");
    nightInt = inputFile->GetInt("NIGHT");
    camera = inputFile->GetStr("CAMERA");
    daq = inputFile->GetStr("DAQ");
    adcCount = inputFile->HasKey("ADCRANGE") ? inputFile->GetFloat("ADCRANGE") : 2000;
    nbOk = 0;//inputFile->GetInt("NBEVTOK");
    nbRej = 0;//inputFile->GetInt("NBEVTREJ");
    nbBad = 0;//inputFile->GetInt("NBEVTBAD");

    eventNum = 0;

#ifdef LOAD_RAW
    nRows = NUM_STORED_EVENTS;
#endif

    if (eventData != NULL) {
        delete[] eventData;
        delete[] rawEventData;
        delete[] waveLetArray;
    }
    eventData = new float[(1440+160)*nRoi];

    rawEventData = new int16_t[(1440+160)*nRoi];
    waveLetArray = new int16_t[1024*1440];
    try
    {
        inputFile->SetPtrAddress("Data", rawEventData);
        inputFile->SetPtrAddress("EventNum", &eventNum);
        inputFile->SetPtrAddress("TriggerType", &triggerType);
        inputFile->SetPtrAddress("SoftTrig", &softTrig);
        inputFile->SetPtrAddress("BoardTime", boardTime);
        inputFile->SetPtrAddress("StartCellData", startPix);
        inputFile->SetPtrAddress("StartCellTimeMarker", startTM);
    }
    catch (const runtime_error &e)
    {
        cout << e.what() << endl;
        cout << "Loading aborted." << endl;

        nRoi = nRows = 0;

        return;
    }

    try
    {
        pcTime[0] = pcTime[1] = 0;
        inputFile->SetPtrAddress("UnixTimeUTC", pcTime);
    }
    catch (const runtime_error&)
    {
        try
        {
            inputFile->SetPtrAddress("PCTime", pcTime);
        }
        catch (const runtime_error&)
        {

        }
    }


    int backupStep = eventStep;
    rowNum = -1;
    eventStep = 1;

    doMyWaveletTestPlease();


    plusEvent();
    eventStep = backupStep;
    emit newFileLoaded();
    emit signalCurrentPixel(selectedPixel);
}
/*
bool RawDataViewer::doWaveLetsPlease(int givenSpan, int16_t* orig_in, int16_t* wavelets_in, bool verifyResult)
{
    float* interArray = new float[givenSpan];
    float* resultArray = new float[givenSpan];
    float* orig = new float[givenSpan];
    float* wavelets = new float[givenSpan];
    for (int i=0;i<givenSpan;i++)
    {
        if (fabs((float)(orig_in[i])) > 32767.f)
            cout << "Input overflow: " << orig_in[i] << endl;
        orig[i] = (float)orig_in[i];
    }
    for (int k=0;k<givenSpan;k++)
        interArray[k] = orig[k];
    int span = givenSpan/2;
    while (span > 0)
    {
        for (int k=0;k<span;k++)
        {
            wavelets[k]        = (interArray[2*k] + interArray[2*k + 1])/2.f;
            wavelets[k + span] = (interArray[2*k + 1] - interArray[2*k])/2.f;
        }
        for (int k=0;k<givenSpan;k++)
            interArray[k] = wavelets[k];
        span /= 2;
    }
    //move float results to int16_t array
    float intScaling = 15.9f;
    int max = 0;
    for (int i=0;i<givenSpan;i++)
    {
        float cValue = intScaling*wavelets[i];//
        if (cValue > 0)
            cValue += 0.5f;
        else
            cValue -= 0.5f;
        wavelets_in[i] = (int16_t)(cValue);
        if (fabs(cValue) >  32767.f)
        {
            cout << "Overflow ! " << cValue << endl;
        }
        if (fabs(cValue) > fabs(max))
            max = cValue;
    }
//    cout << "Max wave value: " << max << endl;
    //result reconstruction and checking
    if (!verifyResult)
        return true;

   for (int k=0;k<givenSpan;k++)
   {
       resultArray[k] = wavelets_in[k]/intScaling;
   }

   span = 1;
   while (span < givenSpan)
   {
       for (int k=0;k<givenSpan;k++)
           interArray[k] = resultArray[k];
      for (int k=0;k<span;k++)
       {
          resultArray[2*k]     = (float)(((interArray[k] - interArray[k + span])*(1.f/1.f)) + 0.0f);
          resultArray[2*k + 1] = (float)(((interArray[k] + interArray[k + span])*(1.f/1.f)) + 0.0f);
       }
       span *= 2;
   }

   for (int k=0;k<givenSpan;k++)
   {
       float plus = 0.5f;
       if (resultArray[k] < 0)
           plus *= -1.f;
       if ((int)(resultArray[k]+plus) != (int)(orig_in[k]))
       {
           cout << "Nop, sorry: k: "  << k << " " << resultArray[k] << " " << (int)(resultArray[k]+plus) << " " << plus << " " << orig[k] << endl;
           return false;
       }
   }
   return true;
}
*/
bool RawDataViewer::doWaveLetsPlease(int givenSpan, int16_t* orig_in, int16_t* wavelets_in, bool verifyResult)
{
    float* interArray = new float[givenSpan];
    float* resultArray = new float[givenSpan];
    float* orig = new float[givenSpan];
    float* wavelets = new float[givenSpan];
    for (int i=0;i<givenSpan;i++)
    {
        if (fabs((float)(orig_in[i])) > 32767.f)
            cout << "Input overflow: " << orig_in[i] << endl;
        orig[i] = (float)orig_in[i];
    }
    for (int k=0;k<givenSpan;k++)
        interArray[k] = orig[k];
    int span = givenSpan/2;
    while (span > 0)
    {
        for (int k=0;k<span;k++)
        {
            wavelets[k]        = interArray[2*k];// + interArray[2*k + 1])/2.f;
            wavelets[k + span] = interArray[2*k + 1] - interArray[2*k];//)/2.f;
        }
        for (int k=0;k<givenSpan;k++)
            interArray[k] = wavelets[k];
        span /= 2;
    }
    //move float results to int16_t array
    float intScaling = 1.f;
    int max = 0;
    for (int i=0;i<givenSpan;i++)
    {
        float cValue = intScaling*wavelets[i];//
        if (cValue > 0)
            cValue += 0.5f;
        else
            cValue -= 0.5f;
        wavelets_in[i] = (int16_t)(cValue);
        if (fabs(cValue) >  32767.f)
        {
            cout << "Overflow ! " << cValue << endl;
        }
        if (fabs(cValue) > fabs(max))
            max = cValue;
    }
//    cout << "Max wave value: " << max << endl;
    //result reconstruction and checking
    if (!verifyResult)
        return true;

   for (int k=0;k<givenSpan;k++)
   {
       resultArray[k] = wavelets_in[k]/intScaling;
   }

   span = 1;
   while (span < givenSpan)
   {
       for (int k=0;k<givenSpan;k++)
           interArray[k] = resultArray[k];
      for (int k=0;k<span;k++)
       {
          resultArray[2*k]     = (float)(((interArray[k])*(1.f/1.f)) + 0.0f);
          resultArray[2*k + 1] = (float)(((interArray[k] + interArray[k + span])*(1.f/1.f)) + 0.0f);
       }
       span *= 2;
   }

   for (int k=0;k<givenSpan;k++)
   {
       float plus = 0.5f;
       if (resultArray[k] < 0)
           plus *= -1.f;
       if ((int)(resultArray[k]+plus) != (int)(orig_in[k]))
       {
           cout << "Nop, sorry: k: "  << k << " " << resultArray[k] << " " << (int)(resultArray[k]+plus) << " " << plus << " " << orig[k] << endl;
           return false;
       }
   }
   delete[] interArray;
   delete[] resultArray;
   delete[] orig;
   delete[] wavelets;
   return true;
}

void RawDataViewer::doWaveLetOnCurrentEventPlease()
{
     int16_t* origTheWayIWant = new int16_t[1024*1440];

//     int numPixels = 1024;
//         int leftOver = 1440-numPixels;
         for (int k=0;k<1024;k++)
             for (int j=0;j<1440;j++)
             {
                 origTheWayIWant[k*1440 + j] = rawEventData[j + k*1440];
             }

         int waveSpan = 1024;
         int waveToPixelsRatio = 32;
         waveSpan = waveSpan*waveToPixelsRatio;
         int totalNumSamples = 1024*1440;
         int j=0;
         for (;j<totalNumSamples;j+= waveSpan)
         {
             if (j + waveSpan < totalNumSamples)
             if (!doWaveLetsPlease(waveSpan, &origTheWayIWant[j], &waveLetArray[j], true))
                 return;
         }

         while (j%1440 != 0)
         {
             int lastRun = 1;
             while (lastRun < 1440 - j%1440)
                 lastRun *= 2;
             lastRun /= 2;
             if (lastRun > 2)
             {
                 doWaveLetsPlease(lastRun, &origTheWayIWant[j], &waveLetArray[j], true);
             }
             else
             {
                 for (int l=0;l<lastRun;l++)
                     waveLetArray[j+l] = origTheWayIWant[j+l];
             }
             if (!lastRun)
                 break;
             j += lastRun;
         }

     delete[] origTheWayIWant;

}
void RawDataViewer::doMyWaveletTestPlease()
{
//    cout << "Size of float: " << sizeof(float) << endl;
    return;
    ofstream outBin("/scratch/bin/outputBin.bin", ios_base::out | ios_base::binary);
    ofstream outWave("/scratch/bin/outputWave.bin", ios_base::out | ios_base::binary);
    int16_t* waveLetArray_ = new int16_t[1024*1440];
    int16_t* origTheWayIWant = new int16_t[1024*1440];

    for (int i=0;i<nRows;i++)
    {
        cout << '\r' <<  "Doing row " << i << " of " << nRows;
        cout.flush();
        inputFile->GetRow(i);
        outBin.write((const char*)(rawEventData), 1440*1024*2);

//       int numPixels = 1024;
//        int leftOver = 1440-numPixels;
        for (int k=0;k<1024;k++)
            for (int j=0;j<1440;j++)
            {
                origTheWayIWant[k*1440 + j] = rawEventData[j + k*1440];
            }

        int waveSpan = 1024;
        int waveToPixelsRatio = 32;
        waveSpan = waveSpan*waveToPixelsRatio;
        int totalNumSamples = 1024*1440;
        int j=0;
        for (;j<totalNumSamples;j+= waveSpan)//1440/waveToPixelsRatio;j++)
        {
            if (j + waveSpan < totalNumSamples)
            if (!doWaveLetsPlease(waveSpan, &origTheWayIWant[j], &waveLetArray_[j], true))
                return;
        }

        while (j%1440 != 0)// < totalNumSamples)
        {
            cout << "Copying the remaining of the data" << endl;
            int lastRun = 1;
            while (lastRun < 1440 - j%1440)//totalNumSamples-j)
                lastRun *= 2;
            lastRun /= 2;
            if (lastRun > 2)
            {
//                   cout << "   Doint one last run of " << lastRun << " samples" << endl;
                doWaveLetsPlease(lastRun, &origTheWayIWant[j], &waveLetArray_[j], true);
            }
            else
            {
//                    cout << " Filling in " << lastRun << " samples" << endl;
                for (int l=0;l<lastRun;l++)
                    waveLetArray_[j+l] = origTheWayIWant[j+l];
            }
            if (!lastRun)
                break;
            j += lastRun;
        }
       outWave.write((const char*)(waveLetArray_), 1440*1024*2);
    }
    outWave.close();
    outBin.close();
    inputFile->GetRow(0);

    delete[] waveLetArray_;
    delete[] origTheWayIWant;
}
void RawDataViewer::openCalibFile(string& file)
{
    //calibrationLoaded = false;

    MessageImp msg;
    if (!DataCalib::ReadFits(file, msg))
    {
        DataCalib::Restart();
        return;
    }
    /*

    calibInputFile = new fits(file);
    if (!*calibInputFile)
    {
        delete calibInputFile;
        calibInputFile = NULL;
        return;
    }

//    if (calibInputFile->HasKey("NROI"))
//    {
//        cout << "Looks like you're trying to load a regular raw data file as DRS calib. aborting." << endl;
//        delete calibInputFile;
//        calibInputFile = NULL;
//        return;
//    }

    if (!calibInputFile->SetPtrAddress("BaselineMean", baseLineMean)){
        cout << "Missing column " << "BaseLineMean" << " Aborting load..." << endl;
        return;}
    if (!calibInputFile->SetPtrAddress("GainMean", gainMean)){
        cout << "Missing column " << "GainMean" << " Aborting load..." << endl;
        return;}
    if (!calibInputFile->SetPtrAddress("TriggerOffsetMean", triggerOffsetMean)){
        cout << "Missing column " << "TriggerOffsetMean" << " Aborting load..." << endl;
        return;}

    calibInputFile->GetNextRow();

 //   for (int i=0;i<1024;i++)
 //       cout << gainMean[i] << " ";
 //   cout << endl << endl;

    delete calibInputFile;
*/
    //calibrationLoaded = true;

    emit newFileLoaded();

    //if (calibratedCheckBox->isChecked())
        updateGL();
}
/************************************************************
 * PLUS EVENT
 ************************************************************/
void RawDataViewer::plusEvent()
{
    eventStepping(true);
}
/************************************************************
 * MINUS EVENT
 ************************************************************/
void RawDataViewer::minusEvent()
{
    eventStepping(false);
}
/************************************************************
 * SET EVENT STEP
 ************************************************************/
void RawDataViewer::setEventStep(int step)
{
    eventStep = step;
}
/************************************************************
 * EVENT STEPPING
 ************************************************************/
void RawDataViewer::eventStepping(bool plus)
{
    if (plus)
        rowNum += eventStep;
    else
        rowNum -= eventStep;
    if (rowNum >= nRows)
        rowNum -= nRows;
    if (rowNum < 0)
        rowNum += nRows;
#ifdef LOAD_RAW
    eventNum+=eventStep;
#else
    if (inputFile == NULL)
        return;
    inputFile->GetRow(rowNum);
//    cout << "Getting row " << rowNum << endl;
    for (int i=0;i<(1440+160)*nRoi;i++)
        eventData[i] = (float)rawEventData[i];
#endif

//    if (drawCalibrationLoaded && calibrationLoaded)
//    {

//    if (calibratedCheckBox->isChecked())
        DataCalib::Apply(eventData, rawEventData, startPix, nRoi);
        CalibData::RemoveSpikes(eventData, nRoi);

        vector<float> pixelStatsData(1440*4);
        CalibData::GetPixelStats(pixelStatsData.data(), eventData, nRoi);


        for (vector<PixelMapEntry>::const_iterator it=fPixelMap.begin(); it!=fPixelMap.end(); it++)
        {
            RMSvalues[it->index] = pixelStatsData[1*1440+it->hw()];
        }

        /*

        for (int i=0;i<1440;i++)
            for (int j=0;j<nRoi;j++)
            {
                int realj = (j+startPix[i])%1024;
                eventData[i*1024+j] *= 2000.f/4096.f;
                eventData[i*1024+j] -= (baseLineMean[i*1024+realj]+triggerOffsetMean[i*1024+j]);
                eventData[i*1024+j] /= gainMean[i*1024+realj];
                eventData[i*1024+j] *= (50000.f/65536.f) * 2500.f;
            }
    }
    */
        if (isVisible())
            updateGL();
    emit signalCurrentEvent(eventNum);
    emit signalCurrentPixel(selectedPixel);
}
/************************************************************
 * NEXT SLICE. deprec ?
 ************************************************************/
void RawDataViewer::nextSlice()
{
    whichSlice++;
    if (whichSlice >= nRoi)
    {
        whichSlice = 0;
        if (!loopCurrentEvent)
        {
            int backupStep = eventStep;
            eventStep = 1;
            eventStepping(true);
            eventStep = backupStep;
        }
    }
    emit signalCurrentSlice(whichSlice);
    updateGL();
}
void RawDataViewer::previousSlice()
{
    whichSlice--;
    if (whichSlice < 0)
    {
        whichSlice = nRoi-1;
        if (!loopCurrentEvent)
        {
            int backupStep = eventStep;
            eventStep = 1;
            eventStepping(false);
            eventStep = backupStep;
        }
    }
    emit signalCurrentSlice(whichSlice);
    updateGL();
}
void RawDataViewer::setCurrentPixel(int pix)
{
    if (pix == -1)
        return;
    selectedPixel = pix;
    if (isVisible())
    updateGL();
     emit signalCurrentPixel(pix);
}
void RawDataViewer::computePulsesStatistics()
{
    if (!inputFile)
    {
        cout << "A FITS file must be open in order to complete this operation" << endl;
        return;
    }


//    for (int i=0;i<nRows;i++)//for all events
//    {
//        inputFile->GetRow(rowNum);
//        for (int i=0;i<(1440+160)*nRoi;i++)
//            eventData[i] = (float)rawEventData[i];

//        for (int j=0;j<ACTUAL_NUM_PIXELS;j++)
///        {
    int j = selectedPixel;
            for (int i=0;i<nRoi;i++)
            {
                aMeas[i] = eventData[j*nRoi+i];// * adcCount;

            }
            for (int i=0;i<nRoi;i++)
            {
                if (i==0)
                    n1mean[i] = aMeas[i+1];
                else
                {
                    if (i==1023)
                        n1mean[i] = aMeas[i-1];
                    else
                        n1mean[i] = (aMeas[i-1]+aMeas[i+1])/2.f;
                }
            }
            //find spike
            for (int i=0;i<nRoi-3;i++)
            {
                const float fract = 0.8f;
                float xx, xp, xpp;
                vCorr[i] = 0;//aMeas[i];
                xx = aMeas[i] - n1mean[i];
                if (xx < -8.f)
                {
                    xp = aMeas[i+1] - n1mean[i+1];
                    xpp = aMeas[i+2] - n1mean[i+2];
                    if ((aMeas[i+2] - (aMeas[i] + aMeas[i+3])/2.f) > 10.f)
                    {
                        vCorr[i+1] = (aMeas[i] + aMeas[i+3])/2.f;
                        vCorr[i+2] = (aMeas[i] + aMeas[i+3])/2.f;
                        i = i+2;
                    }
                    else
                    {
                        if ((xp > -2.*xx*fract) && (xpp < -10.f))
                        {
                            vCorr[i+1] = n1mean[i+1];
                            n1mean[i+2] = aMeas[i+1] - aMeas[i+3]/2.f;
                            i++;
                        }
                    }
                }
            }
            for (int i=0;i<nRoi;i++)
                n1mean[i] = aMeas[i]-n1mean[i];
 //       }
 //   }
}
/************************************************************
 * UICONNECTOR CONSTRUCTOR
 ************************************************************/
UIConnector::UIConnector(QWidget *p)
{
    setupUi(this);
    initHistograms();

    currentFile = "none";
    currentCalibFile = "none";

    updateSpinnerDisplay = true;
    updating = false;

    timer.setInterval(10.0);
    QObject::connect(&timer, SIGNAL(timeout()),
                     this, SLOT(nextSlicePlease()));

    QButtonGroup &scaleGroup = *new QButtonGroup(p);// = new QButtonGroup(canvas);
    QButtonGroup &animateGroup = *new QButtonGroup(p);// = new QButtonGroup(canvas);

    scaleGroup.addButton(currentPixelScale);
    scaleGroup.addButton(entireCameraScale);

    animateGroup.addButton(playEventsRadio);
    animateGroup.addButton(playSlicesRadio);

    entireCameraScale->setChecked(true);

    GLWindow_2->enableText(false);
 //   GLWindow_2->ShowPatchCursor(true);

    QObject::connect(GLWindow, SIGNAL(colorPaletteHasChanged()),
                     this, SLOT(on_autoScaleColor_clicked()));
    QObject::connect(GLWindow, SIGNAL(signalCurrentSlice(int)),
                     this, SLOT(currentSliceHasChanged(int)));
    QObject::connect(GLWindow, SIGNAL(signalCurrentEvent(int)),
                     this, SLOT(currentEventHasChanged(int)));
    QObject::connect(GLWindow, SIGNAL(signalCurrentPixel(int)),
                     this, SLOT(pixelChanged(int)));
    QObject::connect(GLWindow, SIGNAL(newFileLoaded()),
                     this, SLOT(newFileLoaded()));

    QObject::connect(GLWindow_2, SIGNAL(signalCurrentPixel(int)),
                     GLWindow, SLOT(setCurrentPixel(int)));


    show();
}
UIConnector::~UIConnector()
{
    grid1->detach();
    grid2->detach();
    grid3->detach();
    grid4->detach();
    grid5->detach();
    boardsTimeHistoItem.detach();
    startCellHistoItem.detach();
    startTimeMarkHistoItem.detach();
    pixelValueCurveItem.detach();
    aMeanCurveItem.detach();
    vCorrCurveItem.detach();
    meanCurveItem.detach();
}
void UIConnector::slicesPlusPlus()
{
    GLWindow->nextSlice();
}
void UIConnector::slicesMinusMinus()
{
    GLWindow->previousSlice();
}
void UIConnector::on_calibratedCheckBox_stateChanged(int state)
{
    for (int i=0;i<(1440+160)*GLWindow->nRoi;i++)
        GLWindow->eventData[i] = (float)GLWindow->rawEventData[i];

//    if (GLWindow->calibratedCheckBox->isChecked())
    if (state)
    {
        DataCalib::Apply(GLWindow->eventData, GLWindow->rawEventData, GLWindow->startPix, GLWindow->nRoi);
        CalibData::RemoveSpikes(GLWindow->eventData, GLWindow->nRoi);
    }

    GLWindow->updateGL();

    //drawCalibrationCheckBox->setChecked(false);

    on_autoScaleColor_clicked();
    pixelChanged(GLWindow->selectedPixel);

}
/************************************************************
 * DRAW PATCHES CHECK CHANGE. checkbox handler
 ************************************************************/
void UIConnector::on_drawPatchCheckBox_stateChanged(int state)
{
    GLWindow->drawPatch = state;
    GLWindow->updateGL();
}
/************************************************************
 * DRAW IMPULSE CHECK CHANGE. checkbox handler
 ************************************************************/
void UIConnector::on_drawImpulseCheckBox_stateChanged(int state)
{
    GLWindow->drawImpulse = state;
    GLWindow->updateGL();
}
/************************************************************
 * DRAW BLUR CHECK CHANGE. checkbox handler
 ************************************************************/
void UIConnector::on_drawBlurCheckBox_stateChanged(int state)
{
    GLWindow->drawBlur = state;
    GLWindow->updateGL();
}
void UIConnector::on_loopOverCurrentEventBox_stateChanged(int state)
{
    GLWindow->loopCurrentEvent = state;
}

/************************************************************
 * NEXT SLICE PLEASE
 ************************************************************/
void UIConnector::nextSlicePlease()
{
    if (playEventsRadio->isChecked ())
        GLWindow->eventStepping(true);
    else
        GLWindow->nextSlice();
}

/************************************************************
 * SET VIEWER.
 ************************************************************/
//void UIConnector::setViewer(RawDataViewer* v)
//{
//    viewer = v;
//}
/************************************************************
 * SLICES PER SECOND CHANGED. timing ui handler
 ************************************************************/
void UIConnector::slicesPerSecondChanged(double value)
{
    timer.setInterval(1000.0/value);
}

void UIConnector::on_colorRange0_valueChanged(double value) { GLWindow->ss[0] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_colorRange1_valueChanged(double value) { GLWindow->ss[1] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_colorRange2_valueChanged(double value) { GLWindow->ss[2] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_colorRange3_valueChanged(double value) { GLWindow->ss[3] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_colorRange4_valueChanged(double value) { GLWindow->ss[4] = (float)value; GLWindow->updateGL(); }

void UIConnector::on_redValue0_valueChanged(double value) { GLWindow->rr[0] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_redValue1_valueChanged(double value) { GLWindow->rr[1] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_redValue2_valueChanged(double value) { GLWindow->rr[2] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_redValue3_valueChanged(double value) { GLWindow->rr[3] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_redValue4_valueChanged(double value) { GLWindow->rr[4] = (float)value; GLWindow->updateGL(); }

void UIConnector::on_greenValue0_valueChanged(double value) { GLWindow->gg[0] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_greenValue1_valueChanged(double value) { GLWindow->gg[1] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_greenValue2_valueChanged(double value) { GLWindow->gg[2] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_greenValue3_valueChanged(double value) { GLWindow->gg[3] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_greenValue4_valueChanged(double value) { GLWindow->gg[4] = (float)value; GLWindow->updateGL(); }

void UIConnector::on_blueValue0_valueChanged(double value) { GLWindow->bb[0] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_blueValue1_valueChanged(double value) { GLWindow->bb[1] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_blueValue2_valueChanged(double value) { GLWindow->bb[2] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_blueValue3_valueChanged(double value) { GLWindow->bb[3] = (float)value; GLWindow->updateGL(); }
void UIConnector::on_blueValue4_valueChanged(double value) { GLWindow->bb[4] = (float)value; GLWindow->updateGL(); }

/************************************************************
 * LOAD NEW FILE CLICKED. button handler
 ************************************************************/
void UIConnector::on_loadNewFileButton_clicked()
{
    QFileDialog dialog;
    dialog.setFileMode(QFileDialog::ExistingFile);
    dialog.open(this, SLOT(fileSelected(QString)));
    dialog.setVisible(true);
    dialog.exec();
}
void UIConnector::on_loadDRSCalibButton_clicked()
{
    QFileDialog dialog;
    dialog.setFileMode(QFileDialog::ExistingFile);
    dialog.open(this, SLOT(calibFileSelected(QString)));
    dialog.setVisible(true);
    dialog.exec();
}
/************************************************************
 * FILE SELECTED. return of the file open dialog handler
 ************************************************************/
void UIConnector::fileSelected(QString file)
{
    currentFile = file.toStdString();
    if (currentFile != "")
        GLWindow->openFile(currentFile);
}
void UIConnector::calibFileSelected(QString file)
{
    currentCalibFile = file.toStdString();
    if (currentCalibFile != "")
        GLWindow->openCalibFile(currentCalibFile);
}
/************************************************************
 * NEW FILE LOADED. update of the UI after a new file has been loaded
 ************************************************************/
void UIConnector::newFileLoaded()
{
    ostringstream str;

    //extract the file name only (no path) from the full name
    str << "File: " << currentFile.substr(currentFile.find_last_of("//")+1, currentFile.size()) << "\n";
    str << "Calibration: " << currentCalibFile.substr(currentCalibFile.find_last_of("//")+1, currentCalibFile.size()) << "\n";
//    fileLoadedLabel->setText(QString(str.str().c_str()));
//    str.str("");
    str << "Run number: " << GLWindow->runNumber << "\n";
//    runNumberLabel->setText(QString(str.str().c_str()));
//    str.str("");
    str << "Number of Events: " << GLWindow->nRows << "\n";

    displayingEventBox->setMaximum(GLWindow->nRows-1);

    str << "Number of Slices: " << GLWindow->nRoi << "\n";// << "/1024";
//    numberOfSlicesLabel->setText(QString(str.str().c_str()));
//    str.str("");
    str << "Number of Time Marks: " << GLWindow->nTM << "\n";
//    numberOfTimeMarksLabel->setText(QString(str.str().c_str()));

//    str.str("");
    str << "Run Type: " << GLWindow->runType << "\n";
//    runTypeLabel->setText(QString(str.str().c_str()));
//    str.str("");
    str << "Time of 1st data: " << GLWindow->firstDataTime << "\n";
//    firstTimeLabel->setText(QString(str.str().c_str()));
//    str.str("");
    str << "Time of last data: " << GLWindow->lastDataTime << "\n";
//    lastTimeLabel->setText(QString(str.str().c_str()));
//    str.str("");
    str << "SVN revision: " << GLWindow->revision << '\n';
    str << "Number of boards: " << GLWindow->nBoards << '\n';
    str << "Number of pixels: " << GLWindow->nPixels << '\n';
    str << "Number of Slices TM: " << GLWindow->nRoiTM << '\n';
    str << "Time system: " << GLWindow->timeSystem << '\n';
    str << "Date: " << GLWindow->creationDate << '\n';
    str << "Night: " << GLWindow->nightInt << '\n';
    str << "Camera: " << GLWindow->camera << '\n';
    str << "DAQ: " << GLWindow->daq << '\n';
    str << "ADC Count: " << GLWindow->adcCount << '\n';
    str << "NB Evts OK:" << GLWindow->nbOk << '\n';
    str << "NB Evts Rejected: " << GLWindow->nbRej << '\n';
    str << "NB Evts Bad: " << GLWindow->nbBad << '\n';
    extraInfoLabel->setText(QString(str.str().c_str()));

    /*
    if (GLWindow->calibrationLoaded)
    {
        drawCalibrationCheckBox->setEnabled(true);
    }*/


}
/************************************************************
 * PLAY PAUSE CLICKED. ui handler
 ************************************************************/
void UIConnector::on_playPauseButton_clicked()
{
    if (timer.isActive())
        timer.stop();
    else
        timer.start();
}

void UIConnector::displaySliceValue()
{
    if (!GLWindow->nRoi)
        return;

    const int idx =
        GLWindow->nRoi*GLWindow->hardwareMapping[GLWindow->selectedPixel]
        + GLWindow->whichSlice;

    ostringstream str;
    str << "Current Pixel val.: " << GLWindow->eventData[idx];
    currentPixelValue->setText(QString(str.str().c_str()));
}

/************************************************************
 * CURRENT SLICE HAS CHANGE. ui handler
 ************************************************************/
void UIConnector::currentSliceHasChanged(int slice)
{
    if (!GLWindow->nRoi)
        return;

    if (updateSpinnerDisplay)
        displayingSliceBox->setValue(slice);

    displaySliceValue();
}

/*****
 *******************************************************
 * CURRENT EVENT HAS CHANGED. ui handler
 ************************************************************/

double xval[50000];
double yval[50000];
void UIConnector::on_displayingEventBox_valueChanged(int cEvent)
{
//    cout << "Here " << updateSpinnerDisplay << endl;
    if (!updateSpinnerDisplay)
        return;
    updateSpinnerDisplay = false;
//    currentEventHasChanged(cEvent);
    GLWindow->rowNum = cEvent - GLWindow->eventStep;
    GLWindow->eventStepping(true);
    updateSpinnerDisplay = true;

//    GLWindow->updateGL();
}
void UIConnector::on_displayingSliceBox_valueChanged(int cSlice)
{
    updateSpinnerDisplay = false;
    currentSliceHasChanged(cSlice);
    updateSpinnerDisplay = true;
    GLWindow->whichSlice = cSlice;
    GLWindow->updateGL();
}
void UIConnector::currentEventHasChanged(int )
{

    GLWindow_2->SetData(GLWindow->RMSvalues);
    if (GLWindow_2->isVisible())
        GLWindow_2->updateGL();
    ostringstream str;
//    str << "Displaying Event " << cEvent;
//    QString qstr(str.str().c_str());
//    emit updateCurrentEventDisplay(qstr);
    if (updateSpinnerDisplay)
    {
        updateSpinnerDisplay = false;
        displayingEventBox->setValue(GLWindow->rowNum);
        updateSpinnerDisplay = true;
    }

 //   GLWindow->doWaveLetOnCurrentEventPlease();

        //retrieve the data that we want to display
    boost::posix_time::ptime hrTime( boost::gregorian::date(1970, boost::gregorian::Jan, 1),
            boost::posix_time::seconds(GLWindow->pcTime[0]) +  boost::posix_time::microsec(GLWindow->pcTime[1]));

    str.str("");
    str << "PC Time: " << boost::posix_time::to_iso_extended_string(hrTime);
    PCTimeLabel->setText(QString(str.str().c_str()));

    str.str("");
    str << "Software Trigger: " << GLWindow->softTrig;
    softwareTriggerLabel->setText(QString(str.str().c_str()));

    str.str("");
    str << "Trigger Type: " << GLWindow->triggerType;
    triggerTypeLabel->setText(QString(str.str().c_str()));

    displaySliceValue();

    if (autoScaleColor->isChecked())
        emit GLWindow->colorPaletteHasChanged();//autoScalePressed();

    boardsTimeList->clear();
    startPixelsList->clear();
    startTimeMarksList->clear();
    triggerDelayList->clear();
    std::map<int, int> boardsHistoMap;
    for (int i=0;i <NBOARDS; i++)
    {
        str.str("");
        str << i;
        if (i<10) str << " ";
        if (i<100) str << " ";
        if (i<1000) str << " ";
        str << ": " << GLWindow->boardTime[i];
        boardsTimeList->addItem(QString(str.str().c_str()));
        if (boardsHistoMap.find(GLWindow->boardTime[i]) != boardsHistoMap.end())
            boardsHistoMap[GLWindow->boardTime[i]]++;
        else
            boardsHistoMap[GLWindow->boardTime[i]] = 1;
    }
    std::map<int, int> pixelHistoMap;
    for (int i=0;i <NPIX; i++)
    {
        str.str("");
        str << i;
        if (i<10) str << " ";
        if (i<100) str << " ";
        if (i<1000) str << " ";
        str << ": " << GLWindow->startPix[i];
        startPixelsList->addItem(QString(str.str().c_str()));
        if (pixelHistoMap.find(GLWindow->startPix[i]) != pixelHistoMap.end())
            pixelHistoMap[GLWindow->startPix[i]]++;
        else
            pixelHistoMap[GLWindow->startPix[i]] = 1;
    }

    std::map<int, int> timeMarksMap;
    for (int i=0;i <NTMARK; i++)
    {
        str.str("");
        str << i;
        if (i<10) str << " ";
        if (i<100) str << " ";
        if (i<1000) str << " ";
        str << ": " << GLWindow->startTM[i];
        startTimeMarksList->addItem(QString(str.str().c_str()));
        if (timeMarksMap.find(GLWindow->startTM[i]) != timeMarksMap.end())
            timeMarksMap[GLWindow->startTM[i]]++;
        else
            timeMarksMap[GLWindow->startTM[i]] = 1;
    }
    std::map<int,int> delayMap;
    triggerDelayList->addItem(QString("Patch | Slice:Delay Slice:Delay..."));
    for (int i=0;i<NTMARK; i++)
    {
        str.str("");
        str << i << " | ";
        for (int j=0;j<GLWindow->nRoi;j++)
        {
            int value = GLWindow->eventData[1440*GLWindow->nRoi + i*GLWindow->nRoi + j];
            if (delayMap.find(value) != delayMap.end())
                 delayMap[value]++;
             else
                 delayMap[value] = 1;
            str << j << ":" << value << " ";
         }
        triggerDelayList->addItem(QString(str.str().c_str()));
    }

    std::map<int,int>::iterator it = boardsHistoMap.begin();
    int nsamples = 0;
    int previousValue = it->first-10;
    for (unsigned int i=0;i<boardsHistoMap.size();i++)
    {
        if (previousValue != it->first-1)
        {
            xval[nsamples] = previousValue+1;
            yval[nsamples] = 0;
            nsamples++;
            xval[nsamples] = it->first-1;
            yval[nsamples] = 0;
            nsamples++;
        }
        xval[nsamples] = it->first;
        yval[nsamples] = it->second;
        previousValue = it->first;
        it++;
        nsamples++;
        xval[nsamples] = previousValue;
        yval[nsamples] = 0;
        nsamples++;
        if (nsamples > 4090)
        {
            cout << "Error: Maximum number of samples reached for histograms. skipping what's remaining" << endl;
            break;
        }
    }
    xval[nsamples] = it==boardsHistoMap.begin() ? 0 : (--it)->first+1;
    yval[nsamples] = 0;
    nsamples++;
 //   if (nsamples > 5)
#if QWT_VERSION < 0x060000
       boardsTimeHistoItem.setData(xval, yval, nsamples);
#else
       boardsTimeHistoItem.setSamples(xval, yval, nsamples);
#endif

    it = pixelHistoMap.begin();
    nsamples = 0;
    previousValue = it->first-10;
    for (unsigned int i=0;i<pixelHistoMap.size();i++)
    {
        if (previousValue != it->first-1)
        {
            xval[nsamples] = previousValue+1;
            yval[nsamples] = 0;
            nsamples++;
            xval[nsamples] = it->first-1;
            yval[nsamples] = 0;
            nsamples++;
        }
        xval[nsamples] = it->first;
        yval[nsamples] = it->second;
        previousValue = it->first;
        it++;
        nsamples++;
        xval[nsamples] = previousValue;
        yval[nsamples] = 0;
        nsamples++;
        if (nsamples > 4090)
        {
            cout << "Error: Maximum number of samples reached for histograms. skipping what's remaining" << endl;
            break;
        }
   }
    xval[nsamples] = it==pixelHistoMap.begin() ? 0 : (--it)->first+1;
    yval[nsamples] = 0;
    nsamples++;
//    if (nsamples > 5)
#if QWT_VERSION < 0x060000
       startCellHistoItem.setData(xval, yval, nsamples);
#else
       startCellHistoItem.setSamples(xval, yval, nsamples);
#endif

    it = timeMarksMap.begin();
    nsamples = 0;
    previousValue = it->first-10;
    for (unsigned int i=0;i<timeMarksMap.size();i++)
    {
        if (previousValue != it->first-1)
        {
            xval[nsamples] = previousValue+1;
            yval[nsamples] = 0;
            nsamples++;
            xval[nsamples] = it->first-1;
            yval[nsamples] = 0;
            nsamples++;
        }
        xval[nsamples] = it->first;
        yval[nsamples] = it->second;
        previousValue = it->first;
        it++;
        nsamples++;
        xval[nsamples] = previousValue;
        yval[nsamples] = 0;
        nsamples++;
        if (nsamples > 4090)
        {
            cout << "Error: Maximum number of samples reached for histograms. skipping what's remaining" << endl;
            break;
        }
    }
    xval[nsamples] = it==timeMarksMap.begin() ? 0 : (--it)->first+1;
    yval[nsamples] = 0;
    nsamples++;
 //   if (nsamples > 5)
#if QWT_VERSION < 0x060000
       startTimeMarkHistoItem.setData(xval, yval, nsamples);
#else
       startTimeMarkHistoItem.setSamples(xval, yval, nsamples);
#endif

    it = delayMap.begin();
    nsamples = 0;
    previousValue = it->first-10;
    for (unsigned int i=0;i<delayMap.size();i++)
    {
        if (previousValue != it->first-1)
        {
            xval[nsamples] = previousValue+1;
            yval[nsamples] = 0;
            nsamples++;
            xval[nsamples] = it->first-1;
            yval[nsamples] = 0;
            nsamples++;
        }
        xval[nsamples] = it->first;
        yval[nsamples] = it->second;
        previousValue = it->first;
        it++;
        nsamples++;
        xval[nsamples] = previousValue;
        yval[nsamples] = 0;
        nsamples++;
        if (nsamples > 4090)
        {
            cout << "Error: Maximum number of samples reached for histograms. skipping what's remaining" << endl;
            break;
        }
    }
    xval[nsamples] = it==delayMap.begin() ? 0 : (--it)->first+1;
    yval[nsamples] = 0;
    nsamples++;
  //  if (nsamples > 5)
#if QWT_VERSION < 0x060000
       triggerDelayHistoItem.setData(xval, yval, nsamples);
#else
       triggerDelayHistoItem.setSamples(xval, yval, nsamples);
#endif
       //WAVELETS HACK
/*       std::map<int, int> valuesHistoMap;
       std::map<int, int> waveletHistoMap;
       for (int i=0;i<1024*1440;i++)
       {
           if (valuesHistoMap.find(GLWindow->rawEventData[i]) != valuesHistoMap.end())
               valuesHistoMap[GLWindow->rawEventData[i]]++;
           else
               valuesHistoMap[GLWindow->rawEventData[i]] = 1;
           if (waveletHistoMap.find(GLWindow->waveLetArray[i]) != waveletHistoMap.end())
               waveletHistoMap[GLWindow->waveLetArray[i]]++;
           else
               waveletHistoMap[GLWindow->waveLetArray[i]] = 1;
       }

       it = valuesHistoMap.begin();
       nsamples = 0;
       previousValue = it->first-10;
       cout << "Num values Original: " << valuesHistoMap.size() << endl;
       for (unsigned int i=0;i<valuesHistoMap.size();i++)
       {
           if (previousValue != it->first-1)
           {
               xval[nsamples] = previousValue+1;
               yval[nsamples] = 0;
               nsamples++;
               xval[nsamples] = it->first-1;
               yval[nsamples] = 0;
               nsamples++;
           }
           xval[nsamples] = it->first;
           yval[nsamples] = it->second;
           previousValue = it->first;
           it++;
           nsamples++;
           xval[nsamples] = previousValue;
           yval[nsamples] = 0;
           nsamples++;
           if (nsamples > 50000)
           {
               cout << "Error: Maximum number of samples reached for histograms. skipping what's remaining" << endl;
               break;
           }
       }
       xval[nsamples] = it==valuesHistoMap.begin() ? 0 : (--it)->first+1;
       yval[nsamples] = 0;
       nsamples++;
     //  if (nsamples > 5)
   #if QWT_VERSION < 0x060000
          triggerDelayHistoItem.setData(xval, yval, nsamples);
   #else
          triggerDelayHistoItem.setSamples(xval, yval, nsamples);
   #endif

          it = waveletHistoMap.begin();
          nsamples = 0;
          previousValue = it->first-10;
          cout << "Num values WaveLets: " << waveletHistoMap.size() << endl;
          for (unsigned int i=0;i<waveletHistoMap.size();i++)
          {
              if (previousValue != it->first-1)
              {
                  xval[nsamples] = previousValue+1;
                  yval[nsamples] = 0;
                  nsamples++;
                  xval[nsamples] = it->first-1;
                  yval[nsamples] = 0;
                  nsamples++;
              }
              xval[nsamples] = it->first;
              yval[nsamples] = it->second;
              previousValue = it->first;
              it++;
              nsamples++;
              xval[nsamples] = previousValue;
              yval[nsamples] = 0;
              nsamples++;
              if (nsamples > 50000)
              {
                  cout << "Error: Maximum number of samples reached for histograms. skipping what's remaining" << endl;
                  break;
              }
          }
          xval[nsamples] = it==waveletHistoMap.begin() ? 0 : (--it)->first+1;
          yval[nsamples] = 0;
          nsamples++;
        //  if (nsamples > 5)
      #if QWT_VERSION < 0x060000
          startTimeMarkHistoItem.setData(xval, yval, nsamples);
      #else
          startTimeMarkHistoItem.setSamples(xval, yval, nsamples);
      #endif
*/
//END OF WAVELETS HACK
       //    startCellHistoZoom->setZoomBase(startCellHistoItem.boundingRect());
    QStack< QRectF > stack;
//    QRectF cRectangle = boardsTimeHistoItem.boundingRect();
    stack.push(scaleBoundingRectangle(boardsTimeHistoItem.boundingRect(), 1.05f));//cRectangle);//boardsTimeHistoItem.boundingRect());
    boardsTimeHistoZoom->setZoomStack(stack);
    stack.pop();
    stack.push(scaleBoundingRectangle(startCellHistoItem.boundingRect(), 1.05f));
    startCellHistoZoom->setZoomStack(stack);
    stack.pop();
    stack.push(scaleBoundingRectangle(startTimeMarkHistoItem.boundingRect(), 1.05f));
    startTimeMarkHistoZoom->setZoomStack(stack);
    stack.pop();
    stack.push(scaleBoundingRectangle(triggerDelayHistoItem.boundingRect(), 1.05f));
    triggerDelayHistoZoom->setZoomStack(stack);
    stack.pop();

    pixelChanged(GLWindow->selectedPixel);
}
//can't use a ref to rectangle, as the type must be converted first
QRectF UIConnector::scaleBoundingRectangle(QRectF rectangle, float scale)
{
    QPointF bottomRight = rectangle.bottomRight();
    QPointF topLeft = rectangle.topLeft();
    QPointF center = rectangle.center();
    return QRectF(topLeft + (topLeft-center)*(scale-1.0f), //top left
                  bottomRight + (bottomRight-center)*(scale-1.0f)); //bottom right
}
void UIConnector::initHistograms()
{
//    QwtPlot*     boardsTimeHisto;
//    QwtPlotHistogram boardsTimeHistoItem;
    grid1 = new QwtPlotGrid;
    grid1->enableX(false);
    grid1->enableY(true);
    grid1->enableXMin(false);
    grid1->enableYMin(false);
    grid1->setMajPen(QPen(Qt::black, 0, Qt::DotLine));
    grid1->attach(boardsTimeHisto);

    grid2 = new QwtPlotGrid;
    grid2->enableX(false);
    grid2->enableY(true);
    grid2->enableXMin(false);
    grid2->enableYMin(false);
    grid2->setMajPen(QPen(Qt::black, 0, Qt::DotLine));
    grid2->attach(startCellsHisto);

    grid3 = new QwtPlotGrid;
    grid3->enableX(false);
    grid3->enableY(true);
    grid3->enableXMin(false);
    grid3->enableYMin(false);
    grid3->setMajPen(QPen(Qt::black, 0, Qt::DotLine));
    grid3->attach(startTimeMarkHisto);

    grid4 = new QwtPlotGrid;
    grid4->enableX(false);
    grid4->enableY(true);
    grid4->enableXMin(false);
    grid4->enableYMin(false);
    grid4->setMajPen(QPen(Qt::black, 0, Qt::DotLine));
    grid4->attach(pixelValueCurve);

    grid5 = new QwtPlotGrid;
    grid5->enableX(false);
    grid5->enableY(true);
    grid5->enableXMin(false);
    grid5->enableYMin(false);
    grid5->setMajPen(QPen(Qt::black, 0, Qt::DotLine));
    grid5->attach(triggerDelayHisto);

    boardsTimeHisto->setAutoReplot(true);
    startCellsHisto->setAutoReplot(true);
    startTimeMarkHisto->setAutoReplot(true);
    pixelValueCurve->setAutoReplot(true);
    triggerDelayHisto->setAutoReplot(true);
    boardsTimeHisto->setTitle("Boards time values");
    startCellsHisto->setTitle("Start Cell values");
    startTimeMarkHisto->setTitle("Start Time Marks values");
    pixelValueCurve->setTitle("Current pixel values");
    triggerDelayHisto->setTitle("Trigger Delays");

 //   boardsTimeHistoItem.setBrush(QBrush(Qt::red));
//    startCellHistoItem.setBrush(QBrush(Qt::red));
//    startTimeMarkHistoItem.setBrush(QBrush(Qt::red));
//    triggerDelayHistoItem.setBrush(QBrush(Qt::red));
//    pixelValueCurveItem.setBrush(QBrush(Qt::red));

    boardsTimeHistoItem.setPen(QColor(Qt::darkGreen));
    boardsTimeHistoItem.setStyle(QwtPlotCurve::Steps);
    startCellHistoItem.setPen(QColor(Qt::darkGreen));
    startCellHistoItem.setStyle(QwtPlotCurve::Steps);
    startTimeMarkHistoItem.setPen(QColor(Qt::darkGreen));
    startTimeMarkHistoItem.setStyle(QwtPlotCurve::Steps);
    triggerDelayHistoItem.setPen(QColor(Qt::darkGreen));
    triggerDelayHistoItem.setStyle(QwtPlotCurve::Steps);

    boardsTimeHistoItem.attach(boardsTimeHisto);
    startCellHistoItem.attach(startCellsHisto);
    startTimeMarkHistoItem.attach(startTimeMarkHisto);
    triggerDelayHistoItem.attach(triggerDelayHisto);

    //curve
//    pixelValueCurveItem.setSymbol(new QwtSymbol(QwtSymbol::Cross, Qt::NoBrush, QPen(Qt::black), QSize(5,5)));
    pixelValueCurveItem.setPen(QColor(Qt::black));
    aMeanCurveItem.setPen(QColor(Qt::darkGreen));
    vCorrCurveItem.setPen(QColor(Qt::red));
    meanCurveItem.setPen(QColor(Qt::blue));
    pixelValueCurveItem.setStyle(QwtPlotCurve::Lines);
    aMeanCurveItem.setStyle(QwtPlotCurve::Lines);
    vCorrCurveItem.setStyle(QwtPlotCurve::Lines);
    meanCurveItem.setStyle(QwtPlotCurve::Lines);

//    pixelValueCurveItem.setCurveAttribute(QwtPlotCurve::Fitted);
    pixelValueCurveItem.attach(pixelValueCurve);
//    aMeanCurveItem.attach(pixelValueCurve);
 //   vCorrCurveItem.attach(pixelValueCurve);
//    meanCurveItem.attach(pixelValueCurve);

    //FIXME delete these pointers with the destructor
    curveZoom = new QwtPlotZoomer(pixelValueCurve->canvas());
    curveZoom->setRubberBandPen(QPen(Qt::gray, 2, Qt::DotLine));
    curveZoom->setTrackerPen(QPen(Qt::gray));

    boardsTimeHistoZoom = new QwtPlotZoomer(boardsTimeHisto->canvas());
    boardsTimeHistoZoom->setRubberBandPen(QPen(Qt::gray, 2, Qt::DotLine));
    boardsTimeHistoZoom->setTrackerPen(QPen(Qt::gray));

    startCellHistoZoom = new QwtPlotZoomer(startCellsHisto->canvas());
    startCellHistoZoom->setRubberBandPen(QPen(Qt::gray, 2, Qt::DotLine));
    startCellHistoZoom->setTrackerPen(QPen(Qt::gray));

    startTimeMarkHistoZoom = new QwtPlotZoomer(startTimeMarkHisto->canvas());
    startTimeMarkHistoZoom->setRubberBandPen(QPen(Qt::gray, 2, Qt::DotLine));
    startTimeMarkHistoZoom->setTrackerPen(QPen(Qt::gray));

    triggerDelayHistoZoom = new QwtPlotZoomer(triggerDelayHisto->canvas());
    triggerDelayHistoZoom->setRubberBandPen(QPen(Qt::gray, 2, Qt::DotLine));
    triggerDelayHistoZoom->setTrackerPen(QPen(Qt::gray));


}

void UIConnector::pixelChanged(int pixel)
{
    GLWindow_2->fWhite = pixel;
    GLWindow_2->fWhitePatch = GLWindow_2->pixelsPatch[pixel];


    pixel = GLWindow->hardwareMapping[pixel];

    HwIDBox->setValue(pixel);

    if (!GLWindow->nRoi)
        return;

    for (int i=0;i<GLWindow->nRoi;i++)
    {
        xval[i] = i;
#ifdef LOAD_RAW
        yval[i] = eventsData[0][pixel][i];
#else
        yval[i] = GLWindow->eventData[GLWindow->nRoi*pixel + i];
#endif
    }

  //  GLWindow->computePulsesStatistics();
#if QWT_VERSION < 0x060000
    pixelValueCurveItem.setData(xval, yval, GLWindow->nRoi);
////    aMeanCurveItem.setData(xval, GLWindow->aMeas, GLWindow->nRoi);
 //   meanCurveItem.setData(xval, GLWindow->n1mean, GLWindow->nRoi);
 //   vCorrCurveItem.setData(xval, GLWindow->vCorr, GLWindow->nRoi-3);
#else
       pixelValueCurveItem.setSamples(xval, yval, GLWindow->nRoi);
//       aMeanCurveItem.setSamples(xval, GLWindow->aMeas, GLWindow->nRoi);
 //      meanCurveItem.setSamples(xval, GLWindow->n1mean, GLWindow->nRoi);
 //      vCorrCurveItem.setSamples(xval, GLWindow->vCorr, GLWindow->nRoi-3);
#endif


    QStack< QRectF > stack;
    stack.push(scaleBoundingRectangle(pixelValueCurveItem.boundingRect(), 1.5f));
    curveZoom->setZoomStack(stack);
    stack.pop();

    displaySliceValue();
    on_autoScaleColor_clicked();
}

void UIConnector::on_HwIDBox_valueChanged(int)
{
    updating = true;

    const int hwID = HwIDBox->value();

    const int crateID =  hwID/360;
    const int boardID = (hwID%360)/36;
    const int patchID = (hwID%36 )/9;
    const int pixelID =  hwID%9;

    SwIDBox->setValue(GLWindow->softwareMapping[hwID]);

    crateIDBox->setValue(crateID);
    boardIDBox->setValue(boardID);
    patchIDBox->setValue(patchID);
    pixelIDBox->setValue(pixelID);

    updating = false;

    GLWindow->selectedPixel = GLWindow->softwareMapping[hwID];
    GLWindow->updateGL();

    pixelChanged(GLWindow->selectedPixel);
}

void UIConnector::cbpxChanged()
{
    if (updating)
        return;

    const int hwid = crateIDBox->value()*360 + boardIDBox->value()*36 + patchIDBox->value()*9 + pixelIDBox->value();
    HwIDBox->setValue(hwid);
}

void UIConnector::on_SwIDBox_valueChanged(int swid)
{
    if (updating)
        return;

    HwIDBox->setValue(GLWindow->hardwareMapping[swid]);
}

void UIConnector::on_autoScaleColor_clicked()
{
    if (!autoScaleColor->isChecked())
    {
        /*
        GLWindow->ss[0] = 0.496;
        GLWindow->ss[1] = 0.507;
        GLWindow->ss[2] = 0.518;
        GLWindow->ss[3] = 0.529;
        GLWindow->ss[4] = 0.540;;
        colorRange0->setValue(GLWindow->ss[0]);
        colorRange1->setValue(GLWindow->ss[1]);
        colorRange2->setValue(GLWindow->ss[2]);
        colorRange3->setValue(GLWindow->ss[3]);
        colorRange4->setValue(GLWindow->ss[4]);
        */
        return;
    }
    if (!GLWindow->nRoi)
        return;

    int start = 0;
    int end   = 1440;

    if (!entireCameraScale->isChecked())
    {
        start = GLWindow->selectedPixel;
        end   = GLWindow->selectedPixel+1;
    }

    int min =  100000; //real min = -2048, int_16 = -32768 to 32767
    int max = -100000; //real max = 2047

    long average = 0;
    long numSamples = 0;
    int errorDetected = -1;

    for (int i=start;i<end;i++)
    {
        for (int j=0;j<GLWindow->nRoi;j++)
        {
            int cValue = GLWindow->eventData[i*GLWindow->nRoi+j];
            if (cValue > max && cValue < 32767)
                max = cValue;
            if (cValue < min && cValue > -32768)
               min = cValue;
            if (cValue < 32767 && cValue > -32768)
            {
                average+=cValue;
                numSamples++;
            }
            else
            {
                errorDetected = i;
            }
//            numSamples++;
        }
    }
    average /= numSamples;
    if (errorDetected != -1)
    {
        cout << "Overflow detected at pixel " << errorDetected << " (at least)" << endl;
    }
//    cout << "min: " << min << " max: " << max << " average: " << average << endl;
    double minRange = (double)(min+(VALUES_SPAN/2))/(double)VALUES_SPAN;
    double maxRange = (double)(max+(VALUES_SPAN/2))/(double)VALUES_SPAN;
    double midRange = (double)(average+(VALUES_SPAN/2))/(double)VALUES_SPAN;
    if (GLWindow->logScale)
    {
        minRange *= 9;
        maxRange *= 9;
//        midRange *= 9;
        minRange += 1;
        maxRange += 1;
//        midRange += 1;
        minRange = log10(minRange);
        maxRange = log10(maxRange);
//        midRange = (minRange + maxRange)/2.f;
        midRange = log10(midRange);
    }

    GLWindow->ss[0] = minRange;
    colorRange0->setValue(GLWindow->ss[0]);
    GLWindow->ss[4] = maxRange;
    colorRange4->setValue(GLWindow->ss[4]);
//    GLWindow->ss[2] = midRange;
//    range2->setValue(GLWindow->ss[2]);
//    GLWindow->ss[1] = (minRange+midRange)/2;
//    range1->setValue(GLWindow->ss[1]);
//    GLWindow->ss[3] = (maxRange+midRange)/2;
//    range3->setValue(GLWindow->ss[3]);

    GLWindow->ss[2] = (maxRange+minRange)/2;
    colorRange2->setValue(GLWindow->ss[2]);

    GLWindow->ss[1] = minRange+(maxRange-minRange)/4;
    colorRange1->setValue(GLWindow->ss[1]);

    GLWindow->ss[3] = minRange+3*(maxRange-minRange)/4;
    colorRange3->setValue(GLWindow->ss[3]);
}

void PrintUsage()
{
    cout << "\n"
        "The FACT++ raw data viewer.\n"
        "\n"
        "Usage: viewer [OPTIONS] [datafile.fits[.gz] [calibration.drs.fits[.gz]]]\n"
        "  or:  viewer [OPTIONS]\n";
    cout << endl;

}

void PrintHelp()
{
    cout <<
            "\n"
         << endl;
}

int UIConnector::SetupConfiguration(Configuration &conf)
{
    RawDataViewer *canvas = GLWindow;

    if (conf.Has("color.range"))
    {
        vector<double> value = conf.Vec<double>("color.range");
        if (value.size() != 5)
        {
            cout << "Error, colorRange option should have exactly 5 double values" << endl;
            return -1;
        }
        for (int i=0;i<5;i++)
            canvas->ss[i] = value[i];
    }

    if (conf.Has("color.red"))
    {
        vector<double> value = conf.Vec<double>("color.red");
        if (value.size() != 5)
        {
            cout << "Error, colorRed option should have exactly 5 double values" << endl;
            return -1;
        }
        for (int i=0;i<5;i++)
            canvas->rr[i] = value[i];
    }

    if (conf.Has("color.green"))
    {
        vector<double> value = conf.Vec<double>("color.green");
        if (value.size() != 5)
        {
            cout << "Error, colorGreen option should have exactly 5 double values" << endl;
            return -1;
        }
        for (int i=0;i<5;i++)
            canvas->gg[i] = value[i];
    }

    if (conf.Has("color.blue"))
    {
        vector<double> value = conf.Vec<double>("color.blue");
        if (value.size() != 5)
        {
            cout << "Error, colorBlue option should have exactly 5 double values" << endl;
            return -1;
        }
        for (int i=0;i<5;i++)
            canvas->bb[i] = value[i];
    }

    colorRange0->setValue(canvas->ss[0]);
    colorRange1->setValue(canvas->ss[1]);
    colorRange2->setValue(canvas->ss[2]);
    colorRange3->setValue(canvas->ss[3]);
    colorRange4->setValue(canvas->ss[4]);
    redValue0->setValue(canvas->rr[0]);
    redValue1->setValue(canvas->rr[1]);
    redValue2->setValue(canvas->rr[2]);
    redValue3->setValue(canvas->rr[3]);
    redValue4->setValue(canvas->rr[4]);
    greenValue0->setValue(canvas->gg[0]);
    greenValue1->setValue(canvas->gg[1]);
    greenValue2->setValue(canvas->gg[2]);
    greenValue3->setValue(canvas->gg[3]);
    greenValue4->setValue(canvas->gg[4]);
    blueValue0->setValue(canvas->bb[0]);
    blueValue1->setValue(canvas->bb[1]);
    blueValue2->setValue(canvas->bb[2]);
    blueValue3->setValue(canvas->bb[3]);
    blueValue4->setValue(canvas->bb[4]);

    if (conf.Has("drs"))
    {
        const QString qstr(conf.Get<string>("drs").c_str());
        calibFileSelected(qstr);
    }

    if (conf.Has("file"))
    {
        const QString qstr(conf.Get<string>("file").c_str());
        fileSelected(qstr);
    }


    return 0;
}

void SetupConfiguration(Configuration& conf)
{
    po::options_description configs("Raw Events Viewer Options");
    configs.add_options()
        ("color.range", vars<double>(), "Range of the display colours")
        ("color.red",   vars<double>(), "Range of red values")
        ("color.green", vars<double>(), "Range of green values")
        ("color.blue",  vars<double>(), "Range of blue values")
        ("file,f",      var<string>(),  "File to be loaded")
        ("drs,d",       var<string>(),  "DRS calibration file to be loaded")
        ;
    conf.AddOptions(configs);

    po::positional_options_description p;
    p.add("file", 1); // The first positional options
    p.add("drs",  2); // The first positional options
    conf.SetArgumentPositions(p);

}

/************************************************************
 * MAIN PROGRAM FUNCTION.
 ************************************************************/
int main(int argc, const char *argv[])
{
    QApplication app(argc, const_cast<char**>(argv));

    if (!QGLFormat::hasOpenGL()) {
        std::cerr << "This system has no OpenGL support" << std::endl;
        return 1;
    }

    Configuration conf(argv[0]);
    conf.SetPrintUsage(PrintUsage);
    SetupConfiguration(conf);
    if (!conf.DoParse(argc, argv, PrintHelp))
        return 2;

    UIConnector myUi;
    if (myUi.SetupConfiguration(conf)<0)
        return 3;

    return app.exec();
}

