#include "MessageDim.h"

#include "tools.h"
#include "Time.h"

#include <iostream>

int main(int, const char **)
{
   // We could use putenv to make the Configure class change the value...
    setenv("DIM_DNS_NODE", "localhost", 0);

    // Start a DimServer called TIME
    DimServer::start("TIME");

    // Some info on the console
    std::cout << "Offering TIME/MESSAGE...\n" << std::endl;

    // Setup a DimService called TIME/MESSAGE
    MessageDimTX msg("TIME");
    while (1)
    {
        // Send current time
        msg.Message(Time().GetAsStr());

        // wait approximately one second
        usleep(1000000);
    }

    return 0;
}

// **************************************************************************
/** @example logtime.cc

This is a simple example how to log messages through the Dim network
using MessageDimTX. Here we are offering the time once a second.

The program is stopped by CTRL-C

*/
// **************************************************************************
