#!/bin/bash --login


CMD="$*"
PRG="$1"

while [ true ]; do

   reset

   if [ -n "$RC" ]; then
      echo LAST RETURN CODE=$RC
   fi

   echo COMMAND=$CMD
   echo

   if [ ! -x $PRG ]; then
      echo $1 not available... waiting 5s.
      sleep 5
      continue
   fi

   if [ -e compiling.lock ]; then
      echo Compilation in progress... waiting 1s.
      sleep 1
      continue
   fi

   $CMD
   RC=$?

   echo RETURN CODE=$RC
   echo

   # 134 (double corruption, abort())
   # 139 (seg-fault)
   # 255 (exception, exit(-1))

   if [ $RC == 0 -o $RC == 255 ]; then
      exit
   fi

done

