#ifndef FACT_State
#define FACT_State

#include <string>
#include <vector>

struct State
{
    int         index;    /// Index (e.g. 1)
    std::string name;     /// Name (e.g. 'Connected')
    std::string comment;  /// Description (e.g. 'Connection to hardware established.')

    static std::vector<State> SplitStates(const std::string &buffer);

    static bool Compare(const State &i, const State &j) { return i.index<j.index; }

    State(int i, const std::string &n, const std::string &c="");
};

#endif
