#ifndef FACT_StateMachineDimControl
#define FACT_StateMachineDimControl

#include <set>

#include "DimState.h"
#include "StateMachineDim.h"

class Configuration;

class StateMachineDimControl : public StateMachineDim
{
    std::mutex fMutex;

    std::vector<DimDescriptions*> fDimDescriptionsList;

    std::set<std::string> fServerList;
    std::set<Service> fServiceList;
    std::map<std::string, std::vector<std::string>> fCommandList;
    std::map<std::string, State> fCurrentStateList;
    std::map<std::pair<std::string, int32_t>, std::pair<std::string, std::string>> fStateDescriptionList;
    std::map<std::string, std::vector<Description>> fServiceDescriptionList;

    DimVersion fDim;
    DimDnsServiceList fDimList;

    int  fVerbosity;
    bool fDebug;

    std::string fUser;
    std::string fScriptUser;

    std::string Line(const std::string &txt, char fill);

public:
    static bool fIsServer;

    int ChangeState(int qos, const Time &time=Time(), int scriptdepth=-1, std::string scriptfile="", std::string user="");
    int Write(const Time &time, const std::string &txt, int qos=kMessage);

    int StartScript(const EventImp &imp, const std::string &cmd);
    int StopScript();

    int HandleStateChange(const std::string &server, DimDescriptions *state);
    int HandleDescriptions(DimDescriptions *state);
    int HandleStates(const std::string &server, DimDescriptions *state);
    int HandleServerAdd(const std::string &server);
    int HandleServerRemove(const std::string &server);
    int HandleAddService(const Service &svc);

    bool HasServer(const std::string &server);

    std::vector<std::string> GetServerList();
    std::vector<std::string> GetCommandList(const std::string &server);
    std::vector<std::string> GetCommandList();
    std::vector<Description> GetDescription(const std::string &service);

    int PrintStates(std::ostream &out, const std::string &serv="");
    int PrintDescription(std::ostream &out, bool iscmd, const std::string &serv="", const std::string &service="");

    State GetServerState(const std::string &server);

    void SendDimCommand(const std::string &server, std::string str, std::ostream &lout);

public:
    StateMachineDimControl(std::ostream &out=std::cout);
    ~StateMachineDimControl();

    int EvalOptions(Configuration &conf);
};

#endif
