/**
 * @fileOverview
 *    Documentation of Moon class built into dimctrl.
 */

/**
 * @class
 *
 * Calculates the moon's sky position at a given time.
 *
 * When instantiated, the class members are set to the sky position
 * of the moon at the given time. The calculation is done using
 * libnova's ln_get_lunar_equ_coords. A different time can be provided
 * by the user. The sky coordinates are stored together with the time.
 * A function is provided to convert the moon's position to celestial
 * coordinates. A function to calculate the illuminated fraction of
 * the moon's disk.
 *
 * @param {Date} [time=new Date()]
 *    Reference time for the calculation of the moon's position.
 *
 * @example
 *    var moon = new Moon();
 *    var local = moon.toLocal();
 *
 * @author <a href="mailto:thomas.bretz@epfl.ch">Thomas Bretz</a>
 */
function Moon(time)
{
    /**
     * Right ascension of the moon in hours.
     *
     * @type Number
     * @constant
     *
     */
    this.ra = 0;

    /**
     * Declination of the moon in degrees.
     *
     * @type Number
     * @constant
     *
     */
    this.dec = 0;

    /**
     * Time corresponding to the calculated sky coordinates of the moon.
     *
     * @type Date
     * @constant
     */
    this.time = time;

    /**
     * Converts the moon's sky coordinates to celestial coordinates.
     * As observatory location the FACT telescope is assumed. For the
     * time, the time corresponding to the stored sky coordinates is used.
     * The conversion is done using libnova's ln_get_hrz_from_equ.
     *
     * @returns {Local}
     *     A Local object with the converted coordinates and
     *     the corresponding time.
     */
    this.toLocal = function() { /* [native code] */  }
}

/**
 * Calculates the illuminated fraction of the moon's disk for the
 * provided time. If no time is provided, the current system time
 * is used. The calculation is done using libnova's ln_get_lunar_disk.
 *
 * @param {Date} [time=new Date()]
 *    Time for which the moon disk should be calculated. If no time is
 *    given, the current time is used.
 *
 * @type Number
 *
 * @returns
 *    The illuminated fraction of the moon's disk corresponding
 *    to the time argument
 *
 */
Moon.disk = function() { /* [native code] */ }
