throw new Error("Description for built in functions. Must not be included!");
/**
 * @fileOverview
 *    Documentation of the Thread object
 */

/**
 * @class
 *
 * Creates a handle to a new thread.
 *
 * The handle can be used to
 * kill the thread or be ignored. The function provided is
 * executed after an initial timeout. Note that although this
 * looks similar to the setTimeout in web-browsers, after started,
 * the thread will not run until completion but run in parallel to
 * the executed script.<P>
 *
 * To stop the script from within a thread, use exit(). To stop only
 * execution of the thread (silently) throw a null exception
 * ("throw null;"). To terminate the script with an exception
 * throw a normal exception ("throw new Error("my error");").
 *
 * @param {Integer} timeout
 *    A positive integer given the initial delay in milliseconds before
 *    the thread is executed.
 *
 * @param {Function} function
 *    A function which is executed aftr the initial timeout.
 *
 * @throws
 *    <li> If number or type of arguments is wrong
 *
 * @example
 *    var handle = new Thread(100, function() { dim.out("Hello world!"); });
 *    ...
 *    handle.kill();
 */
function Thread(timeout, function)
{
    /**
     *
     * Kills a running thread
     *
     * @returns {Boolean}
     *     If the thread was still known, true is returned, false
     *     otherwise. If the thread terminated already, false is
     *     returned.
     *
     */
    this.kill = function() { /* [native code] */ }
};
