throw new Error("Description for built in functions. Must not be included!");
/**
 * @fileOverview
 *    Documentation of the dimctrl namespace
 */

/**
 * @namespace
 *
 * Global namespace for functions dealing with the dimctrl state
 *
 * @author <a href="mailto:thomas.bretz@epfl.ch">Thomas Bretz</a>
 */
var dimctrl = { };

/**
 * Define a new internal state.
 *
 * States should be defined when a script is started.
 *
 * @param {Integer} index
 *    The intgeger number assigned to the new state. Only numbers
 *    in the range [10, 255] are allowed.
 *
 * @param {String} [name]
 *    A short name describing the state. According the the convention
 *    used throughout FACT++, it it must not contain whitespaces or
 *    underscores. Ever word should start with a capital letter,
 *    e.g. 'TriggerOn'
 *
 * @param {String} [decription]
 *    A user defined string which gives a more conscise explanation
 *    of the meaning of the state and can also be displayed in the GUI
 *    or anywhere else automatically,
 *    e.g. "System setup and trigger switched on"
 *
 * @throws
 *    <li> if something is wrong with the supplied arguments (type, number)
 *    <li> when the index is out of range [10,255]
 *    <li> the given state name is empty
 *    <li> the given state name contains a colon or an equal sign
 *    <li> when a state with the same name or index was already
 *    <li> set since the script was started.
 *
 * @returns {Boolean}
 *    A boolean whether the state was newly added (true) or an existing
 *    one overwritten (false).
 *
 * @example
 *     dim.defineState(10, "StateTen", "This is state number ten");
 */
dimctrl.defineState = function() { /* [native code] */ }

/**
 * Change the internal state.
 *
 * @param {Integer,String} state
 *    Either the name of the state to set or its index can be supplied.
 *
 * @throws
 *    <li> if something is wrong with the supplied arguments (type, number)
 *    <li> if a String is given and it is not found in the list of names
 *
 * @returns {Boolean}
 *     A boolean is returned whether setting the state wa sucessfull or
 *     not. If the function is not called at unexpected time, i.e.
 *     before the execution of the JavaScript has been started or
 *     after it has already be terminated, true should be returned
 *     always.
 *
 * @example
 *     dim.setState(10);
 *     dim.setState("StateTen");
 */
dimctrl.setState = function() { /* [native code] */ }

/**
 * Get the current internal state.
 *
 * @throws
 *    if arguments are supplied
 *
 * @returns {Object}
 *     An object with the properties index {Number}, name {String} and
 *     description {String}. Note that name and description might be
 *     an empty string.
 *
 * @example
 *     var state = dim.getState();
 *     console.out(JSON.stringify(state));
 */
dimctrl.getState = function() { /* [native code] */ }
