// switch agilent control output on
function handleAgilentPowerOn(wait_state)
{
    var state = dim.state("AGILENT_CONTROL");
    if (state===undefined)
        return undefined;

    if (wait_state && wait_state.length>0 && state.name!=wait_state)
        return wait_state;

    //dim.print("AGILENT_CONTROL:  "+state.name+"["+state.index+"]");

    switch (state.name)
    {
    case "Disconnected":
    case "Connected":
        return undefined;

    case "VoltageLow":
        return wait_state;

    case "VoltageOff":
        console.out("Agilent in VoltageOff... switching agilent output on.");
        dim.send("AGILENT_CONTROL/SET_POWER", true);
        return "VoltageOn";

    case "VoltageOn":
        return "";

    case "VoltageHigh":
        throw new Error("Agilent reports voltage above limit... please check.");
    }

    throw new Error("AGILENT_CONTROL:"+state.name+"["+state.index+"] unknown or not handled.");
}
