#!/bin/bash --login


CMD="$*"
PRG="$1"

while [ true ]; do

   reset

   if [ -n "$RC" ]; then
      echo LAST RETURN CODE=$RC
   fi

   echo COMMAND=$CMD
   echo

   if [ ! -x $PRG ]; then
      echo $1 not available... waiting 5s.
      sleep 5
      continue
   fi

   if [ -e compiling.lock ]; then
      echo Compilation in progress... waiting 1s.
      sleep 1
      continue
   fi

   $CMD
   RC=$?

   echo RETURN CODE=$RC
   echo

   # HUP    1  exit
   # INT    2  exit
   # QUIT   3  core
   # ILL    4  core
   # TRAP   5  core
   # ABRT   6  core
   # FPE    8  core
   # KILL   9  exit
   # SEGV  11  core
   # PIPE  13  exit
   # ALRM  14  exit
   # TERM  15  exit

   # 0    (User requested exit from the command line)
   # 1-   (Eval options failed, return code of StateMachineImp::Run)
   # 126  (exit requested from recompile.sh)
   # 127  (problem with option parsing or no program start, like --help)
   # 128  (exit(128))
   # 134  (ABRT, double corruption, abort())
   # 139  (SEGV, 128+11)
   # 255  (exception)

   if [ $RC -eq 126 ]; then
      continue
   fi

   # RC<=128 || RC==KILL || RC=TERM || RC=exception
   if [ $RC -le 128 ] || [ $RC -eq 137 ] || [ $RC -eq 143 ] || [ $RC -eq 255 ] ]; then
      exit
   fi

done

