#ifndef FACT_DataWriteFits2
#define FACT_DataWriteFits2

#include "DataProcessorImp.h"
#include "externals/ofits.h"

#include <array>

class DataWriteFits2 : public DataProcessorImp
{
    std::ofits fFile;

    std::array<uint32_t, 8> fTriggerCounter;

    uint32_t fTstart[2];
    uint32_t fTstop[2];

    void WriteHeader(const RUN_HEAD* h, const FAD::RunDescription &d);
    void WriteFooter(RUN_TAIL *rt);

    virtual int GetDrsStep() const { return -1; }

public:
    DataWriteFits2(const std::string path, uint64_t night, uint32_t runid, MessageImp &imp) :
        DataProcessorImp(path, night, runid, imp)
    {
    }

    bool Open(const RUN_HEAD* h, const FAD::RunDescription &d);
    bool WriteEvt(EVENT *e);
    bool Close(RUN_TAIL *rt = 0);

    Time GetTstart() const { return Time(fTstart[0], fTstart[1]); }
    Time GetTstop() const  { return Time(fTstop[0],  fTstop[1]);  }

    static void WriteDefaultKeys(std::ofits &file);
};

#endif
