'use strict';

//
// this file contains just the implementation of the
// Observation class (I know there are no classes in javascript...)
//

function Observation(obj)
{
    if (typeof(obj)!='object')
        throw new Error("Observation object can only be constructed using an object.");

    if (!obj.date)
        throw new Error("Observation object must have a 'date' parameter");

    // FIXME: Check transisiton from summer- and winter-time!!
    var utc = new Date(obj.date);
    if (isNaN(utc.valueOf()))
        throw new Error(obj.date+' is not a valid Date String.'+
                        ' Try something like "2013-01-08 23:05 UTC" .');

    this.start  = utc;
    this.task   = obj.task ? obj.task.toUpperCase() : "DATA";
    this.source = obj.source;
    this.ra     = obj.ra;
    this.dec    = obj.dec;
    
    switch (this.task)
    {
    case 'DATA':
        if (this.source == undefined)
            throw new Error("Observation must have either 'source' or 'task' " +
                            "if 'task' == 'data' it must have also have 'source' ");
        break;

    case 'STARTUP':
        if (this.source != undefined)
            console.out("warning. Observation with task='startup' also has source defined");
        break;

    case 'SHUTDOWN':
        if (this.source != undefined)
            console.out("warning. Observation with task='shutdown' also has source defined");
        break;

    case 'RATESCAN':
        if (this.source == undefined && (this.ra == undefined || this.dec == undefined))
            throw new Error("Observation must have either 'source' or 'ra' & 'dec' " +
                            "if 'task' == 'ratescan'");
        break;

    default:
        throw new Error(" the task of this observation:"+this.task+
                        "is not implemented. use one of: DATA, STARTUP, SHUTDOWN, RATESCAN.");
    }
}

// method toString()
Observation.prototype.toString = function() 
{
    if (this.source)
        return this.task + "  " + this.source+" ["+this.start+"]" ;
    else
        return this.task + " ["+this.start+"]" ;
}
