#ifndef FACT_Tools
#define FACT_Tools

#include <map>
#include <string>
#include <vector>

namespace Tools
{
    std::string Format(const char *fmt, va_list &ap);
    std::string Form(const char *fmt, ...);
    std::string Trim(const std::string &str);
    std::string TrimQuotes(const std::string &str);
    std::string Wrap(std::string &str, size_t width=78);
    std::string Scientific(uint64_t val);

    std::map<std::string,std::string> Split(std::string &, bool = false);
    std::vector<std::string> Split(const std::string &, const std::string &);
    std::string Uncomment(const std::string &opt);
}

#endif
