# Try to find the package via pkg-config
PKG_CHECK_MODULES(QWT qwt QUIET)

# Try to locate the package in the default path
# and in the path provided by pkg-config
FIND_PATH(QWT_INCLUDE_DIR NAMES qwt-qt4/qwt.h PATHS ${QWT_INCLUDE_DIRS})
FIND_LIBRARY(QWT_LIBRARY NAMES qwt-qt4 PATHS ${QWT_LIBRARY_DIRS})

# Check if QWT_LIBARARY and QWT_INCLUDE_DIR is set
# Print a message otherwise
FIND_PACKAGE_HANDLE_STANDARD_ARGS(QWT DEFAULT_MSG QWT_LIBRARY QWT_INCLUDE_DIR)

# Mark those variables to be displayed as 'advanced' in the GUI
MARK_AS_ADVANCED(QWT_LIBRARY QWT_INCLUDE_DIR)
