/***************************************************************************
                          amcserialport.h  -  description
                             -------------------
    begin                : Sun Nov 24 2002
    copyright            : (C) 2002 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.					   *
 ***************************************************************************/

#ifndef AMCSERIALPORT_H
#define AMCSERIALPORT_H

#include <termios.h>

#define BAUDRATE B115200
#define BAUDRATE2 B57600
#define MODEMDEVICE "/dev/ttyS%d"

/**
  *@author Martin Merck
  */

class AMCSerialPort {
public: 
  AMCSerialPort();
  ~AMCSerialPort();
  /** No descriptions */
  void init( const char* p_pPort );
  /** Write one charachter to the serial port */
  int transmitChar( char ch );
  /** No descriptions */
  int readBlock( char* p_pBuffer, int p_iMaxLen );

private: // Private attributes
  /** File descripor representing the open serial port */
  int m_fd;
  /** Structure to hold the original terminal IO setup. We will restore it when leaving the program. */
  struct termios m_oldtio;
};

#endif
