#ifndef CALIBRATELASERMOVMENTDIALOG_H
#define CALIBRATELASERMOVMENTDIALOG_H

#include "calibratelasermovementdialogbase.h"
#include <qthread.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qlist.h>

class AMCFrameGrabber;
class AMCMotor;
class AMCMirrorPanel;
class LinearRegression;
class FrameEvent;
class VideoSpot;

class CalibrateLaserMovementDialog : public CalibrateLaserMovementDialogBase, public QThread
{
	Q_OBJECT

public:
	CalibrateLaserMovementDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags f = 0 );
	virtual ~CalibrateLaserMovementDialog();
	virtual void customEvent( QCustomEvent* e );
	virtual void run();

public slots:
	virtual void startThread();
  virtual void stop();

private:
	void processSpot( int p_iX, int p_iY );
	void findSpot( int& p_iY, int& p_iY );
	int getThreshold();
	void checkStop();
	void outputProgress( QString qsMsg );
	void outputError( QString qsMsg );
  /** No descriptions */
  void substractDark();
	AMCFrameGrabber*	m_pFG;
	AMCMotor*					m_pMotor;
	AMCMirrorPanel*		m_pCurrentPanel;
	LinearRegression* m_pXLinearRegression;
	LinearRegression* m_pYLinearRegression;
	QList<VideoSpot>  m_qlSpotList;
	QMutex						m_aMutex;
	uchar*						m_pData;
	uchar*						m_pDark;
	bool 							m_zRun;
	int								m_iSpotX;
	int								m_iSpotY;
	QFile							m_qfFile;
	QTextStream				m_qtsStream;

};
#endif
