/***************************************************************************
                          videodisplay.h  -  description
                             -------------------
    begin                : Sat Apr 5 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VIDEODISPLAY_H
#define VIDEODISPLAY_H

#include <qwidget.h>
#include <videodisplaybase.h>
#include <qlist.h>
#include "amcframegrabber.h"

/**
  *@author Martin Merck
  */
class QTimer;
class AMCMotor;
class AMCMirrorPanel;
class CenterThread;
class VideoFrame;

class VideoDisplay : public VideoDisplayBase  {
   Q_OBJECT
public: 
	VideoDisplay(QWidget *parent=0, const char *name=0, bool modal = FALSE);
	~VideoDisplay();
  /** Set the motor of the panel to use. */
  void setMotor( AMCMotor* p_pMotor );
  /** Set the motor of the panel to use. */
  void setPanel( AMCMirrorPanel* p_pPanel );
  /** Handle events from the motor threads. */
	void customEvent( QCustomEvent* e );

private: // Private attributes
  /** The framegrabber instance we use in this dialog. */
//  AMCFrameGrabber* m_theFG;
  /**  */
  VideoFrame* m_videoFrame;
  /** pointer to the currently used motor class. */
  AMCMotor* m_pMotor;
  /** pointer to the currently used motor class. */
  AMCMirrorPanel* m_pPanel;
  /** pointer to the thread used to center a panel. */
	CenterThread* m_pCenterThread;
  /** pointer to a timer we use to calculate the frame grabbing rate. */
  QTimer* m_pTimer;

public slots: // Public slots
  /** Store the actual image in a fie
 */
  virtual void storeSlot();
  /** No descriptions */
  virtual void setSpotInfoSlot( int p_iX, int p_iY );
  /** No descriptions */
  virtual void setGRefInfoSlot( int p_iX, int p_iY );
  /** Move the X motor 10 steps forward. */
  virtual void incX10Slot() { moveMotors( 10, 0 ); };
  /** Move the X motor 100 steps forward. */
  virtual void incX100Slot() { moveMotors( 100, 0 ); };
  /** Move the X motor 10 steps downward. */
  virtual void decX10Slot() { moveMotors( -10, 0 ); };
  /** Move the X motor 100 steps downward. */
  virtual void decX100Slot() { moveMotors( -100, 0 ); };
  /** Move the Y motor 10 steps forward. */
  virtual void incY10Slot() { moveMotors( 0, 10 ); };
  /** Move the Y motor 100 steps forward. */
  virtual void incY100Slot() { moveMotors( 0, 100 ); };
  /** Move the Y motor 10 steps downward. */
  virtual void decY10Slot() { moveMotors( 0, -10 ); };
  /** Move the Y motor 100 steps downward. */
  virtual void decY100Slot() { moveMotors( 0, -100 ); };
  /** Center the motors. */
  virtual void centerSlot();
  /** Goto the position given by X. */
  virtual void goXSlot();
  /** Goto the position given by Y. */
  virtual void goYSlot();
  /** Switch the laser on. */
  virtual void switchLaserSlot( bool p_zOn );
  /** Move motors relative by the given amount of steps. */
  virtual void moveMotors( int x, int y );
private:
  /** No descriptions */
  void enableButtons( bool p_zEnable ) const;
	void calcSteps( int p_iRefX, int p_iRefY, int& p_iStepX, int& p_iStepY );
	
public slots: // Public slots
  /** Save laser position as global reference. */
  void saveGRefSlot();
  /** Save actual laser position as reference. */
  void saveRefSlot();
  /** No descriptions */
  void adjustGRefSlot();
  /** No descriptions */
  void adjustRefSlot();
  /** No descriptions */
  void defocusAllSlot();
  /** No descriptions */
  void focusAllSlot();
  /** No descriptions */
  void defocusSlot();
  /** No descriptions */
  void focusSlot();
  /** No descriptions */
  void clearDarksSlot();
  /** No descriptions */
  void takeDarkSlot();
  /** No descriptions */
  void calibrateSlot();
  /** No descriptions */
  void accept();
};

#endif
