/***************************************************************************
                          videospot.cpp  -  description
                             -------------------
    begin                : Thu Aug 28 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "videospot.h"
#include "stdlib.h"

VideoSpot::VideoSpot()
{
	m_iNumPixel = 0;
	m_iXSum = 0;
	m_iYSum = 0;
	m_iWSum = 0;
}

VideoSpot::VideoSpot( int p_iX, int p_iY )
{
	m_iNumPixel = 10;
	m_iXSum = p_iX;
	m_iYSum = p_iY;
	m_iWSum = 1;
}

VideoSpot::~VideoSpot()
{
}

/** No descriptions */
bool VideoSpot::contains( int p_iX, int p_iY )
{
	if( ( abs( p_iX - getX() ) < 10 )
			&&
			( abs( p_iY - getY() ) < 10 ) )
		return true;
	else
		return false;
}

/** No descriptions */
bool VideoSpot::contains2( int p_iX, int p_iY )
{
	if( ( abs( p_iX - getX() ) < 25 )
			&&
			( abs( p_iY - getY() ) < 25 ) )
		return true;
	else
		return false;
}

/** No descriptions */
void VideoSpot::append( int p_iX, int p_iY, int p_iWeight )
{
//	if( contains( p_iX , p_iY  ) )
//		m_glPixels.append( new VideoPixel( p_iX, p_iY, p_iWeight ) );
		m_iXSum += p_iX * p_iWeight;
		m_iYSum += p_iY * p_iWeight;
		m_iWSum += p_iWeight;
		m_iNumPixel++;
}

/** No descriptions */
int VideoSpot::getX()
{
	return ( m_iXSum / m_iWSum );
}

/** No descriptions */
int VideoSpot::getY()
{
	return ( m_iYSum / m_iWSum );
}
/** No descriptions */
bool VideoSpot::isValid()
{
	return ( m_iNumPixel >= 3 );
}
