/***************************************************************************
                          AMCMirrorPanel.h  -  description
                             -------------------
    begin                : Sat Nov 23 2002
    copyright            : (C) 2002 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.                                    *
 *                                                                         *
 ***************************************************************************/

#ifndef AMCMIRRORPANEL_H
#define AMCMIRRORPANEL_H


/**
  *@author Martin Merck
  */

class AMCMirrorPanel {
public: 
	AMCMirrorPanel( int ii, int ij, int iType, int iPort, int iBox, int iDriver);
	~AMCMirrorPanel();
	/** return the type (orientation) of the panel for selecting
			the correct icon */
	int type() const { return m_iType; }
	/** return the serial port number for this panel */
	int port() const { return m_iPort; }
	/** return the AMC box number for this panel */
	int box() const { return m_iBox; }
	/** return the AMC druver number for this panel */
	int driver() const { return m_iDriver; }
	/** return the panel index I */
	int i() const { return m_i; }
	/** return the panel index J */
	int j() const { return m_j; }
	/** query if this panel is installed */
	bool isInstalled() const { return m_zInstalled; }
	/** mark this panel as installed in the dish */
	void setInstalled( bool zInst) { m_zInstalled = zInst; }
	/** query if this panel is reversed for the axis */
	bool isReversed() const { return m_zReversed; }
	/** mark this panel as reversed for the axis */
	void setReversed( bool zRev) { m_zReversed = zRev; }
	/** query if laser is on */
	bool isLaserOn() const { return m_zLaserOn; }
	/** set laser to on */
	void setLaserOn( bool zOn ) { m_zLaserOn = zOn; }
	/** Query if motor power is on */
	bool isPowerOn() const { return m_zMotorPower; }
	/** turn motor power on */
	void setPowerOn( bool zOn ) { m_zMotorPower = zOn; }
	/** get current position of motor in steps from centered */
	int getX() const { return m_iX; }
	/** get current position of motor in steps from centered */
	void setX( int p_iX ) { m_iX = p_iX; }
	/** get current position of motor in steps from centered */
	int getY() const { return m_iY; }
	/** get current position of motor in steps from centered */
	void setY( int p_iY ) { m_iY = p_iY; }
	/** get reference position of motor in steps from centered */
	int getRefX() const { return m_iRefX; }
	/** get reference position of motor in steps from centered */
	void setRefX( int p_iX ) { m_iRefX = p_iX; }
	/** get reference position of motor in steps from centered */
	int getRefY() const { return m_iRefY; }
	/** set reference position of motor in steps from centered */
	void setRefY( int p_iY ) { m_iRefY = p_iY; }
	/** get laser position X for reference position of motors */
	double getLaserX() const { return m_dLaserX; }
	/** set laser position X for reference position of motors */
	void setLaserX( double p_dX ) { m_dLaserX = p_dX; }
	/** get laser position Y for reference position of motors */
	double getLaserY() const { return m_dLaserY; }
	/** set laser position Y for reference position of motors */
	void setLaserY( double p_dY ) { m_dLaserY = p_dY; }
	/** get laser position Y for reference position of motors */
	double getAxisX() const { return m_dAxisX; }
	/** set laser position Y for reference position of motors */
	void setAxisX( double p_dX ) { m_dAxisX = p_dX; }
	/** get laser position Y for reference position of motors */
	double getAxisY() const { return m_dAxisY; }
	/** set laser position Y for reference position of motors */
	void setAxisY( double p_dY ) { m_dAxisY = p_dY; }
	/** get laser position Y for reference position of motors */
	double getSlopeX() const { return m_dSlopeX; }
	/** set laser position Y for reference position of motors */
	void setSlopeX( double p_dX ) { m_dSlopeX = p_dX; }
	/** get laser position Y for reference position of motors */
	double getSlopeY() const { return m_dSlopeY; }
	/** set laser position Y for reference position of motors */
	void setSlopeY( double p_dY ) { m_dSlopeY = p_dY; }
	/** get laser position Y for reference position of motors */
	double getConversionX() const { return m_dConversionX; }
	/** set laser position Y for reference position of motors */
	void setConversionX( double p_dX ) { m_dConversionX = p_dX; }
	/** get laser position Y for reference position of motors */
	double getConversionY() const { return m_dConversionY; }
	/** set laser position Y for reference position of motors */
	void setConversionY( double p_dY ) { m_dConversionY = p_dY; }
	/** get laser position Y for reference position of motors */
	int getStepsX() const { return m_iStepsX; }
	/** set laser position Y for reference position of motors */
	void setStepsX( int p_iX ) { m_iStepsX = p_iX; }
	/** get laser position Y for reference position of motors */
	int getStepsY() const { return m_iStepsY; }
	/** set laser position Y for reference position of motors */
	void setStepsY( int p_iY ) { m_iStepsY = p_iY; }
  /** Here we calculation a correction for the laser spot position.
 */
  double calcCorrection();
  /** No descriptions */
  void calcSteps( double p_dX, double p_dY, int& p_iStepsX, int& p_iStepsY );
  /** No descriptions */
  void getCorrectedRef( double& p_dRefX, double& p_dRefY );

private: // Public attributes
	/**  */
	int m_i;
	int m_j;
	int m_iType;
	int m_iPort;
	int m_iBox;
	int m_iDriver;
	bool m_zInstalled;
	bool m_zReversed;
	/** Hold information if laser is on */
	bool m_zLaserOn;
	/** Hold information if motor power is on */
	bool m_zMotorPower;
	/** Current position of X motor. */
	int m_iX;
	/** Current position of Y motor. */
	int m_iY;
	/** Reference position of X motor. */
	int m_iRefX;
	/** Reference position of Y motor. */
	int m_iRefY;
	/** Laser X position position for reference position. */
	double m_dLaserX;
	/** Laser Y position position for reference position. */
	double m_dLaserY;
	/** X axis of regression line for X motor. */
	double m_dAxisX;
	/** X slope of regression line for X motor. */
	double m_dSlopeX;
	/** Conversion factor from camera pixels to motor steps for X motor. */
	double m_dConversionX;
	/** Y axis of regression line for Y motor. */
	double m_dAxisY;
	/** Y slope of regression line for Y motor. */
	double m_dSlopeY;
	/** Conversion factor from camera pixels to motor steps for Y motor. */
	double m_dConversionY;
	/** Laser X position position for reference position. */
	int m_iSpotX;
	/** Laser Y position position for reference position. */
	int m_iSpotY;
	/** Laser X position position for reference position. */
	int m_iStepsX;
  /** Laser Y position position for reference position. */
	int m_iStepsY;
};

#endif
