// laseradjustthreadcontroller.cpp: Implementierung der Klasse MotorThreadController.
//
//////////////////////////////////////////////////////////////////////

#include "laseradjustthreadcontroller.h"
#include "laseradjustthread.h"
#include "amcmirrorpanel.h"
#include "amcframegrabber.h"
#include <qthread.h>

extern AMCFrameGrabber* g_pFG;

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

LaserAdjustThreadController::LaserAdjustThreadController( QList<AMCMirrorPanel>& p_qlPanels, QObject* p_pReceiver )
	: ThreadController( p_qlPanels, p_pReceiver )
{
	m_pData = new uchar[ g_pFG->getBuffsize()];
}

LaserAdjustThreadController::~LaserAdjustThreadController()
{
	delete[] m_pData;
}

void LaserAdjustThreadController::run()
{
	for( AMCMirrorPanel* pActualPanel = m_qlPanels.first();
		 pActualPanel; pActualPanel = m_qlPanels.next() )
	{
		if( m_zStop )
			return;
		LaserAdjustThread* pThread = new LaserAdjustThread( m_pReceiver );
		pThread->setPanel( pActualPanel );
		pThread->setData( m_pData );
		pThread->start();
		pThread->wait();
		delete pThread;
	}

	return;
}
