/***************************************************************************
                          videothread.h  -  description
                             -------------------
    begin                : Sat Aug 30 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VIDEOTHREAD_H
#define VIDEOTHREAD_H

#include <qthread.h>

/**
  *@author Martin Merck
  */
class AMCFrameGrabber;


class VideoThread : public QThread  {
public: 
	VideoThread( QObject* p_pReceiver, AMCFrameGrabber* p_pFG );
	virtual ~VideoThread();

  /** No descriptions */
  virtual void init( int p_iSize );

  /** No descriptions */
  virtual void stop();

  /** No descriptions */
  virtual void getLastFrame( uchar* p_pData );

protected: // Protected methods
  /** No descriptions */
  virtual void run();

private:
	QObject*					m_pReceiver;
	AMCFrameGrabber*	m_pFG;
	bool							m_zValid;
	bool							m_zRun;
	int								m_iCurFrame;
	int								m_iSize;
	QMutex 					 	m_aMutex;
	uchar*						m_pData[2];
};

#endif
