/***************************************************************************
                          activemirrorcontrol.h  -  description
                             -------------------
    begin                : Wed Mar 26 14:23:48 UTC 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***********************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ACTIVEMIRRORCONTROL_H
#define ACTIVEMIRRORCONTROL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "activemirrorcontrolbase.h"
#include <qtimer.h>

class AMCCmdServerSocket;
class AMCReportSocket;
class AMCState;
class HEATState;
class QDateTime;

/** ActiveMirrorControl is the base class of the porject */
class ActiveMirrorControl : public ActiveMirrorControlBase
{
  Q_OBJECT 

public:
    /** construtor */
    ActiveMirrorControl(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~ActiveMirrorControl();
		bool getZdAz( double& p_dZd, double& p_dAz );
		int getNumLoops() { return m_iLoops; }

public slots:
  virtual void userModeSlot();
  virtual void stateChangedSlot( int p_iOldState, int p_iNewState );
  virtual void heatStateChangedSlot( int p_iOldState, int p_iNewState );
  /** Slot invoked when no connection to CC is possible. */
  void ccNoConnection();
  /** No descriptions */
  void reconnectCCTimeout();
  /** Move the mirrors manually. */
  void moveManuallySlot();
  /** Slot invoked to start the calibration dialog. */
  void centerAllSlot();
  /** Slot invoked to start the calibration dialog. */
  void calibrateSlot();
  /** Perform a lookup table adjustment. */
  void adjustSlot();
  /** No descriptions */
  void autoFocusSlot( bool p_zOn );

private slots: // Private slots
	/** Slot invoked when we got a connection from Central Control */
	void cmdConnected();
	/** Slot called when connection to CC is closed */
	void cmdDisconnected();
	/** Slot envoked when we receive a command from Central Control */
	void cmdReceived( QString m_qsCmd );
	/** Slot envoked when we receive a report from Central Control */
	void ccReportReceived( QString m_qsReport );
	/** Log a message to the statuis window */
  /** Slot envoked when we get a reporting connection to the CC
  */
  void ccReportConnection();
	void logMessage( QString p_qsMsg );
  /** Slot envoked each time a report is send to CC */
  void reportDelivered( QDateTime& p_qtReportTime , QString& p_qsReport );
  /** Perform a laser adjustment. */
  void laserAdjustSlot();
  /** Perform a laser adjustment. */
  void errorTestSlot();

private:
	AMCCmdServerSocket*	m_pCmdServerSocket;
	AMCReportSocket*		m_pReportSocket;
  bool								m_zCCMode;
  bool								m_zAutoFocus;
  /** State stored during user mode */
  int									m_iStoredState;
  /** Number of loops for error testing */
  int									m_iLoops;
  /** Timer used to retry a connection to CC. */
  QTimer							m_qtCCRetryTimer;

};

#endif
