// laseradjustthread.h: Schnittstelle fr die Klasse MotorThread.
//
//////////////////////////////////////////////////////////////////////

#ifndef LASERADJUSTTHREAD_H
#define LASERADJUSTTHREAD_H


#include <qthread.h>
#include <qlist.h>

class AMCMirrorPanel;
class	VideoSpot;

class LaserAdjustThread : public QThread
{

public:
	LaserAdjustThread( QObject* p_pReceiver );
	virtual ~LaserAdjustThread();

	void setPanel( AMCMirrorPanel* p_pPanel );
	void setLaser( bool p_zOn ) { m_zOn = p_zOn; };
	void setData( uchar* p_pData ) { m_pData = p_pData; };
	AMCMirrorPanel* getPanel() { return m_pPanel; };
  /** No descriptions */
  void calcCenter();
  /** No descriptions */
  void calcSteps( int& p_iX, int& p_iY );
  /** No descriptions */
  void getDistToRef( double& p_dX, double& p_dY );
  /** No descriptions */
  void getSpot();
  /** No descriptions */
  int getThreshold();

protected:
	virtual void run();
private:
	AMCMirrorPanel* 	m_pPanel;
	QObject*					m_pReceiver;
	uchar*						m_pData;
	bool							m_zOn;
  /**  */
  int								m_iCenterX;
  /**  */
  int								m_iCenterY;
  /**  */
  int								m_iSpotX;
  /**  */
  int								m_iSpotY;
  /** No descriptions */
	QList<VideoSpot>  m_qlSpotList;
  /** No descriptions */
	QList<VideoSpot>  m_qlSpots;
};

#endif
