/***************************************************************************
                          amcerror.h  -  description
                             -------------------
    begin                : Sun Nov 24 2002
    copyright            : (C) 2002 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.					   *
 ***************************************************************************/

#ifndef AMCERROR_H
#define AMCERROR_H

#include <qstring.h>
#include <qdatetime.h>

/**
  * This class intended to be used as the exception class
  * we throw when we encounter an error.
  *@author Martin Merck
  */

class AMCError {
public: 
	AMCError( const char* p_sError = 0, int p_iDriver = 0 );
	~AMCError();
	/** Return the driver number of the driver generating the error. */
	int getDriver() const { return m_iDriver; }
	/** Set the driver number of the driver generating the error. */
	void setDriver( int p_iDriver );
	/** return the Panel originating the error. */
	void getPanel( int& p_iX, int& p_iY) const { p_iX = m_iX; p_iY = m_iY;  }
	/** Set the Panel originating the error. */
	void setPanel( int p_iX, int p_iY) { m_iX = p_iX; m_iY = p_iY;  }
	/** Return a reference to the string describing the error. */
	const QString& getErrorText() const;
	/** Set the text describing the error condition. */
	void setErrorText( const char* p_sError );
	/** No descriptions */
	void setCommand( QCString p_sCommand ) { m_sCommand = p_sCommand; }
	/** No descriptions */
	void setResponse( QCString p_sResponse ) { m_sResponse = p_sResponse; }
	/** No descriptions */
	QString formatError( int iNumSpace = 0 ) const;
private: // Private attributes
	/** Description of the error */
	/**  */
 	QCString m_sCommand;
 	QCString m_sResponse;
	QString m_sError;
  int m_iDriver;
  int m_iX, m_iY;
	/**  */
	QDateTime m_time;
};

#endif
