/***************************************************************************
                          AMCMirrorPanel.h  -  description
                             -------------------
    begin                : Sat Nov 23 2002
    copyright            : (C) 2002 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.                                    *
 *                                                                         *
 ***************************************************************************/

#ifndef AMCFRAMEGRABBER_H
#define AMCFRAMEGRABBER_H


/**
  *@author Martin Merck
  */

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/mman.h>
#include <errno.h>
#include <qobject.h>

/* Video for Linux Two */
#include </usr/src/linux/include/linux/videodev.h>

#define FMT_FLAG V4L2_FMT_FLAG_INTERLACED
//#define FMT_FLAG V4L2_FMT_FLAG_INTERLACED

#define MY_WIDTH  640
#define MY_HEIGHT 480
//#define MY_DEPTH  3
#define MY_DEPTH  4
//#define MY_WIDTH  768
//#define MY_HEIGHT 576
//#define MY_WIDTH  320
//#define MY_HEIGHT 240
#define BUFSIZE		(MY_WIDTH * MY_HEIGHT * MY_DEPTH)

//#define MY_PIXEL_FORMAT V4L2_PIX_FMT_BGR24
#define MY_PIXEL_FORMAT V4L2_PIX_FMT_BGR32

class QMutex;

class AMCFrameGrabber : public QObject
{
   Q_OBJECT

public:
	AMCFrameGrabber();
	virtual ~AMCFrameGrabber();
	
	virtual int grabFrame( uchar* p_pData );

	virtual uint getBuffsize() const;
	/** */
	virtual int getBrightness() { return( getControl( V4L2_CID_BRIGHTNESS ) ); };
	/** */
	virtual int getContrast() { return( getControl( V4L2_CID_CONTRAST ) ); };
	/** */
	virtual int getSaturation() { return( getControl( V4L2_CID_SATURATION ) ); };
	/** */
	virtual int getHue() { return( getControl( V4L2_CID_HUE ) ); };
	/** */
	virtual QMutex* getMutex() { return( m_pMutex ); };

protected: // Protected methods
	virtual void getPixelFormats();
	/** */
	virtual void getBufferFormats();
	/** */
	virtual void getVideoStandards();
	/** */
	virtual void getStandard();
	/** */
	virtual void setStandardPAL();
	/** */
	virtual void setStandardNTSC();
	/** */
	virtual void getControls();
	/** */
	virtual void setControl( unsigned int p_iCtrl, int p_iValue );
	/** */
	virtual int getControl( unsigned int p_iCtrl );
	
public slots: // Public slots
  /** Set the birghtness control. */
  void setBrightness( int p_iBrightness ) { setControl( V4L2_CID_BRIGHTNESS, p_iBrightness); };
  /** Set the contrast control. */
  void setContrast( int p_iContrast) { setControl( V4L2_CID_CONTRAST, p_iContrast); };
  /** Set the birghtness control. */
  void setSaturation( int p_iSaturation ) { setControl( V4L2_CID_SATURATION, p_iSaturation); };
  /** Set the contrast control. */
  void setHue( int p_iHue ) { setControl( V4L2_CID_HUE, p_iHue); };

private: // Private attributes
	/** Offset into data buffer where to start next send */
	int											m_iOffset;
	
	char*										m_pDevice;
	int											m_iVid;
	int											m_iErr;
	int											m_iBuffsize;
	struct v4l2_capability	m_stCap;
	struct v4l2_format			m_stFmt;
  struct v4l2_fmtdesc	 		m_stFmtDesc;
  struct v4l2_queryctrl		m_stCtrlDesc;
	struct v4l2_enumstd			m_stEnumStd;
	struct v4l2_standard		m_stStandard;
	struct v4l2_standard		m_stStdPAL;
	struct v4l2_standard		m_stStdNTSC;
	QMutex*									m_pMutex;
};

#endif
