/***************************************************************************
                          amclog.cpp  -  description
                             -------------------
    begin                : Mon Aug 25 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.				                 	   *
 ***************************************************************************/

#include <qfile.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qregexp.h>
#include <qtextstream.h>
#include "amclog.h"
#include "amcerror.h"

AMCLog::AMCLog()
{
	QDateTime theDT = QDateTime::currentDateTime();
	QDate theDate = theDT.date();
	QTime theTime = theDT.time();
	QString qsFileName;
	qsFileName.sprintf( "/home/amc/data/AMC_%04d_%02d_%02d_%02d_%02d_%02d.log",
                      theDate.year(), theDate.month(), theDate.day(),
                      theTime.hour(), theTime.minute(), theTime.second() );
	m_qfFile.setName( qsFileName );
	if( ! m_qfFile.open( IO_WriteOnly ) )
	{
		qDebug( "ERROR: Can't open file: %s\n", qsFileName.latin1() );
	}
	m_qtsStream.setDevice( &m_qfFile );
	m_qtsStream	<< "AMC Log started at: " << theDT.toString() << endl;
	m_qfFile.flush();
}

AMCLog::~AMCLog()
{
	QDateTime theDT = QDateTime::currentDateTime();
	m_qtsStream	<< "AMC Log closed at:  " << theDT.toString() << endl;
	m_qfFile.close();
}

void AMCLog::logError( const QString& p_qsMsg1, const AMCError& e )
{
	QDateTime theDT = QDateTime::currentDateTime();
	m_qtsStream << "ERROR: " << "[ " << theDT.toString() << "]" << endl;
	m_qtsStream << "       " << p_qsMsg1 << endl;
	m_qtsStream << e.formatError(7) << endl;
	m_qfFile.flush();
}

void AMCLog::logWarning( const QString& p_qsMsg1, const QString& p_qsMsg2 )
{
	QDateTime theDT = QDateTime::currentDateTime();
	m_qtsStream << "[" << theDT.toString() << " " << p_qsMsg1 << "]" << endl;
	m_qtsStream << QString( p_qsMsg2 ).replace( QRegExp("/012"), "" ) << endl << endl;
	m_qfFile.flush();
}

void AMCLog::logInfo( const QString& p_qsMsg1, const QString& p_qsMsg2 )
{
	QDateTime theDT = QDateTime::currentDateTime();
	m_qtsStream << "[" << theDT.toString() << " " << p_qsMsg1 << "]" << endl;
	m_qtsStream << QString( p_qsMsg2 ).replace( QRegExp("/012"), "" ) << endl << endl;
	m_qfFile.flush();
}


