// ThreadEvent.h: Schnittstelle fr die Klasse ThreadEvent.
//
//////////////////////////////////////////////////////////////////////

#ifndef THREADEVENT_H
#define THREADEVENT_H


#include <qevent.h>
#include <amcerror.h>
#define THREAD_EVENT (QEvent::User + 1)
#define PROGRESS_EVENT (QEvent::User + 2)
#define THREAD_ERROR_EVENT (QEvent::User + 3)
#define THREAD_END_EVENT (QEvent::User + 4)
#define THREAD_FRAME_EVENT (QEvent::User + 5)
#define THREAD_SPOT_EVENT (QEvent::User + 6)

class ThreadEvent : public QCustomEvent
{
public:
	ThreadEvent( QString p_qsMsg );
	virtual ~ThreadEvent();
	QString getMessage() { return m_qsMsg; };

private:
	QString m_qsMsg;
};

class ThreadErrorEvent : public QCustomEvent
{
public:
	ThreadErrorEvent( QString p_qsMsg, AMCError& p_theError );
	virtual ~ThreadErrorEvent();
	QString getMessage() { return m_qsMsg; };
	AMCError& getError() { return m_theErr; };

private:
	AMCError	m_theErr;
	QString 	m_qsMsg;
};

#endif
