/***************************************************************************
                          adjustmirrordlg.h  -  description
                             -------------------
    begin                : Sat Nov 23 08:23:53 UTC 2002
    copyright            : (C) 2002 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.					   *
 ***************************************************************************/

#ifndef ADJUSTMIRRORDLG_H
#define ADJUSTMIRRORDLG_H

//#ifdef HAVE_CONFIG_H
//#include <config.h>
//#endif

#include <qwidget.h>
#include "adjustmirrordlgbase.h"
#include "mirrorselector.h"

class AMCSerialPort;
class AMCMotor;

/** AdjustMirrorDlg is the base class of the porject */
class AdjustMirrorDlg : public AdjustMirrorDlgBase
{
  Q_OBJECT 
  public:
    /** construtor */
    AdjustMirrorDlg(QWidget* parent=0, const char *name=0, bool modal = FALSE);
    /** destructor */
    ~AdjustMirrorDlg();

public: // Public attributes
  /**  */
  MirrorSelector* m_mirrorWidget;

private: // Private attributes
  /** pointer to the currently used motor class. */
  AMCMotor* m_pMotor;
  /** Internal variable to hold currently selected panel. */
  AMCMirrorPanel* m_pCurrentPanel;
  /** Context menu, shown when the user hits the right mouse button.  */
  QPopupMenu* m_contextMenu;

public slots: // Public slots
  /** No descriptions */
  virtual void mirrorSelectedSlot( AMCMirrorPanel* pPanel );
  /** Move the X motor 10 steps forward. */
  virtual void incX10Slot() { moveMotors( 10, 0 ); };
  /** Move the X motor 100 steps forward. */
  virtual void incX100Slot() { moveMotors( 100, 0 ); };
  /** Move the X motor 10 steps downward. */
  virtual void decX10Slot() { moveMotors( -10, 0 ); };
  /** Move the X motor 100 steps downward. */
  virtual void decX100Slot() { moveMotors( -100, 0 ); };
  /** Move the Y motor 10 steps forward. */
  virtual void incY10Slot() { moveMotors( 0, 10 ); };
  /** Move the Y motor 100 steps forward. */
  virtual void incY100Slot() { moveMotors( 0, 100 ); };
  /** Move the Y motor 10 steps downward. */
  virtual void decY10Slot() { moveMotors( 0, -10 ); };
  /** Move the Y motor 100 steps downward. */
  virtual void decY100Slot() { moveMotors( 0, -100 ); };
  /** Center the motors. */
  virtual void centerSlot();
  /** Power motors on or off. */
  virtual void powerMotorsSlot();
  /** Switch the laser on. */
  virtual void switchLaserSlot( bool p_zOn );
  /** Set he motor parameters. */
  virtual void setParamsSlot();
  /** Goto the position given by X. */
  virtual void goXSlot();
  /** Goto the position given by Y. */
  virtual void goYSlot();
  /** No descriptions */
  virtual void closeEvent( QCloseEvent* e );
  /** Check to see if the right mouse button was pressed and show the context menu in this case. */
  virtual void mousePressEvent( QMouseEvent* p_pEvent );
  /** Move motors relative by the given amount of steps. */
  virtual void moveMotors( int x, int y );
  /** show / hide video. */
  virtual void videoSlot();
  /** No descriptions */
  void adjustIcons();
private: // Private methods
  /** No descriptions */
  void enableButtons( bool p_zEnable ) const;
  /** No descriptions */
	void allLasersOnOff( QString p_qsMsg, bool p_zOn);
private slots: // Private slots
  /** Save the positions to the file. */
  void savePositionsSlot();
public slots: // Public slots
  /** No descriptions */
  void allLasersOnSlot();
  /** No descriptions */
  void allLasersOffSlot();
};

#endif
