
/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Wed Mar 26 14:23:48 UTC 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kapp.h>
#include <stdio.h>

#include "activemirrorcontrol.h"
#include "amcframegrabber.h"
#include "amclog.h"
#include "amcserialport.h"
#include "amcstate.h"
#include "amccmdstate.h"
#include "heatstate.h"
#include "magicmirror.h"

KApplication*			g_theApp = 0;
AMCSerialPort*		g_pPort[8];
AMCLog*						g_pLog;
AMCFrameGrabber*	g_pFG;
MagicMirror*			g_theMirror;
AMCState* 				g_pAMCState;
HEATState* 				g_pHEATState;
AMCCmdState*			g_pAMCCmdState;
double						g_dRefX, g_dRefY;

static const char *description =
	I18N_NOOP("ActiveMirrorControl");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

  KAboutData aboutData( "activemirrorcontrol", I18N_NOOP("ActiveMirrorControl"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2003, Martin Merck", 0, 0, "merck@astro.uni-wuerzburg.de");
  aboutData.addAuthor("Martin Merck",0, "merck@astro.uni-wuerzburg.de");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication a;
	g_theApp = &a;
	qDebug("Creating AMCLog");
	g_pLog = new AMCLog();
	qDebug("Creating AMCFrameGrabber");
	g_pFG = new AMCFrameGrabber();
	qDebug("Creating AMCState");
	g_pAMCState = new AMCState( 0 );
	qDebug("Creating HEATState");
	g_pHEATState = new HEATState( 0 );
	qDebug("Creating AMCCmdState");
	g_pAMCCmdState = new AMCCmdState( 0 );

	// First we open and initialize the 8 serial ports
	char	portName[256];
	
	for(int i=0; i<8; i++)
	{
		AMCSerialPort* pPort = new AMCSerialPort();
		// The serial ports of the Meilhaus ME9100 card
		// begin at /dev/ttyS4 and go to /dev/ttyS11
		sprintf( portName, "/dev/ttyS%d", i+4);
		try
		{
			pPort->init( portName );
			g_pPort[i] = pPort;
		}
		catch( AMCError& e )
		{
			QString qMsg(portName);
			g_pLog->logError( qMsg, e );
		}
	}	
	qDebug("Creating MagicMirror");
	g_theMirror = new MagicMirror();
	g_dRefX = -1.;
	g_dRefY = -1.;

	qDebug("Creating ActiveMirrorControl");
  ActiveMirrorControl *activemirrorcontrol = new ActiveMirrorControl();
  a.setMainWidget(activemirrorcontrol);
  activemirrorcontrol->show();

	int rc = a.exec();

	qDebug("Deleting ActiveMirrorControl");
  delete activemirrorcontrol;
	qDebug("Deleting SerialPorts");
	for(int i=0; i<8; i++)
		delete g_pPort[i];

	qDebug("Deleting MagicMirror");
  delete g_theMirror;
	qDebug("Deleting AMCState");
	delete g_pAMCState;
	qDebug("Deleting HeatState");
	delete g_pHEATState;
	qDebug("Deleting AMCCmdState");
	delete g_pAMCCmdState;
	qDebug("Deleting FrameGrabber");
	delete g_pFG;
	qDebug("Deleting AMCLog");
  delete g_pLog;

  return rc;
}
