/***************************************************************************
                          mirrorselector.h  -  description
                             -------------------
    begin                : Sat Nov 23 2002
    copyright            : (C) 2002 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.					   *
 ***************************************************************************/

#ifndef MIRRORSELECTOR_H
#define MIRRORSELECTOR_H

#include <qbuttongroup.h>

class AMCPushButton;
class AMCMirrorPanel;
class QGridLayout;

/**This widget contains a Buttongroup for all 
  * the mirror panels.
  *@author Martin Merck
  */

class MirrorSelector : public QButtonGroup {
   Q_OBJECT
public: 
	MirrorSelector(QWidget *parent=0, const char *name=0);
	~MirrorSelector();
	
	/** Check to see if the right mouse button was pressed and show the context menu in this case. */
	void mousePressEvent( QMouseEvent* p_pEvent );
	
public: // Public attributes

	/** Array containing the buttons for the individual mirror panels */
	AMCPushButton* m_mirrorButton[17][17];
	/** Our own widget for selecting individual mirror panels */
	QGridLayout* m_mirrorGroupLayout;
	
protected slots: // Protected slots

	/** Hanling a selection of a panel by the user */
	virtual void buttonSelectedSlot( int );
	/** Save the positions to the file. */
	void savePositionsSlot();
	
private: // Private attributes

	/** Array containing the abstraction of the mirror definitions */
	AMCMirrorPanel* m_Panel[17][17];
	/** Number of panels really installed */
	int m_iNumPanels;
	/** Context menu, shown when the user hits the right mouse button.  */
	QPopupMenu* m_contextMenu;
	/** Array conmtaining the pixmaps for the icons of the buttons.  */
	QPixmap* m_pixType[13];
	/** Array conmtaining the bitmaps for the icon masks of the buttons.  */
	QBitmap* m_bitMask[6];
	/** Pointer to the currently selected button.  */
	QButton* m_pSelectedButton;
	
signals: // Signals

	/** We propagate the selection with the pointer to the AMCMirrorPanel
		datastructure as a parameter.
	 */
	void panelSelectedSignal( AMCMirrorPanel* );
	
private: // Private methods

	/** Read he panel descriptions from the file "Panels.txt".
		This file contains for each panel a line with the following contents:
		i	j	type	port	box		driver	installed
	
		i: is the first panel index (counting from left to right)
		j: is the second panel index (counting from bottom to top)
		type: the panel type (see the file for a description of types)
		port: the serial port this box is connected to.
			  (The numbering corresponds to the numbers on the cables.
			   If only 1 Meilhaus ME8100 card is installed on linux boxes
			   we have the following correspondance to device files
			   port 1 == /dev/ttyS4 ... port 8 = /dev/ttyS11)
		box: the number of the AMC box.
		driver: The internal AMC driver to which this panel is connected.
		installed: Flag indicating if this panel is installed (0=no, 1=yes)
	*/
//	void readPanelDescription();
	
	/** Here we read the stored panel positions from the file PanelPos.txt
		We then go through all panels, center them and go to the stored position.
	 */
	void initPanelPositions();

	/** Read the stored panel positions from the file "PanelPos.txt"
	    This file contains for each panel a line with the following contents:
	    i	j	X	Y
	
	    i: is the first panel index (counting from left to right)
	    j: is the second panel index (counting from bottom to top)
	    X: position of the X motor relative to the center position
	    Y: position of the Y motor relative to the center position
     */
//  void readPanelPositions();
public slots: // Public slots
  /** Change the icon to show that the laser is on or off.
 */
  void toggelLaser(  AMCMirrorPanel* p_pPanel, bool p_zOn );
};

#endif
