// errortestthreadcontroller.cpp: Implementierung der Klasse ErrorTestThreadController.
//
//////////////////////////////////////////////////////////////////////

#include "errortestthreadcontroller.h"
#include "errortestthread.h"
#include "amcmirrorpanel.h"
#include "amcframegrabber.h"
#include <qthread.h>

extern AMCFrameGrabber* g_pFG;

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

ErrorTestThreadController::ErrorTestThreadController( QList<AMCMirrorPanel>& p_qlPanels, QObject* p_pReceiver )
	: ThreadController( p_qlPanels, p_pReceiver )
{
	m_pData = new uchar[ g_pFG->getBuffsize()];
  m_iLoops = 0;
}

ErrorTestThreadController::~ErrorTestThreadController()
{
	delete[] m_pData;
}

void ErrorTestThreadController::run()
{
  for( int i=0; i<m_iLoops; i++ )
  {
		for( AMCMirrorPanel* pActualPanel = m_qlPanels.first();
			 pActualPanel; pActualPanel = m_qlPanels.next() )
		{
			if( m_zStop )
				return;
			ErrorTestThread* pThread = new ErrorTestThread( m_pReceiver );
			pThread->setPanel( pActualPanel );
			pThread->setData( m_pData );
			pThread->start();
			pThread->wait();
			delete pThread;
		}
		QThread::postEvent( m_pReceiver, new QCustomEvent( PROGRESS_EVENT ) );
  }

	return;
}
