/***************************************************************************
                          linearregression.h  -  description
                             -------------------
    begin                : Tue Apr 8 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LINEARREGRESSION_H
#define LINEARREGRESSION_H


/**Performs a linear regression through the points given.
  *@author Martin Merck
  */

class LinearRegression
{
public: 
	LinearRegression();
	~LinearRegression();
	void reset();
	void addPoint( int p_iX, int p_iY );
	void addPoint( double p_dX, double p_dY );
	bool isValid() { return( ( m_iNum > 1 ) ? true : false ); };
	double getAxis();
	double getSlope();
	double getR();
	const bool getReversed () const { return m_zReversed; }
	void setReversed ( bool p_zReversed ) { m_zReversed = p_zReversed; }

private:
	double m_dSX;					// Sum over all X
	double m_dSY; 				// Sum over all Y
	double m_dSXY;				// Sum over all X * Y
	double m_dSXX;				// Sum over all X^2
	double m_dSYY;				// Sum over all Y^2
	int m_iNum;
  bool	m_zReversed;
};

#endif
