// threadcontroller.h: Schnittstelle fr die Klasse MotorThreadController.
//
//////////////////////////////////////////////////////////////////////

#ifndef THREADCONTROLLER_H
#define THREADCONTROLLER_H

#define LASER_THREAD_CTRL	1
#define MOTOR_THREAD_CTRL	2
#define DEFOCUS_THREAD_CTRL 3
#define ADJUST_THREAD_CTRL 4
#define LASER_ADJUST_THREAD_CTRL 5
#define ERROR_TEST_THREAD_CTRL 6

#include <qthread.h>
#include <qlist.h>

class AMCMirrorPanel;
class LaserThreadController;
class MotorThreadController;

class ThreadController : public QThread
{
public:
	ThreadController( QList<AMCMirrorPanel>& p_qlPanels, QObject* p_pReceiver );
	virtual ~ThreadController();
	virtual void setBool( bool p_zTrue ) { m_zTrue = p_zTrue; };
  /** No descriptions */
  static ThreadController* getController( int p_iType, QList<AMCMirrorPanel>& p_qlPanels, QObject* p_pReceiver );
  /** No descriptions */
  void stop();

protected:
	QList<AMCMirrorPanel> m_qlPanels;     // List of mirror panels to start workers for.
	QObject*							m_pReceiver;    // Reciever of the Events posted by the worker thraeads.
	bool									m_zTrue;        // Flag used by the controller to pass to worker threads
																				// Used to indicate if lasers should be turned on or off
																				// or if we should defocus or focus the mirror.
protected: // Public attributes
  /**  */
  bool m_zStop;
};

#endif

