/***************************************************************************
                          amclog.h  -  description
                             -------------------
    begin                : Mon Aug 25 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.			                		   *
 ***************************************************************************/

#ifndef AMCLOG_H
#define AMCLOG_H

#include <qfile.h>
#include <qtextstream.h>

/**
  * This class intended to be used as the exception class
  * we throw when we encounter an error.
  *@author Martin Merck
  */

class AMCError;
class QString;

class AMCLog {
public: 
	AMCLog();
	~AMCLog();
	/** Log an error to the logfile. */
	void logError( const QString& p_qsMsg1, const AMCError& e );
	/** Log an error to the logfile. */
	void logWarning( const QString& p_qsMsg1, const QString& p_qsMsg2 );
	/** Log an error to the logfile. */
	void logInfo( const QString& p_qsMsg1, const QString& p_qsMsg2 );
private: // Private attributes
	QFile					m_qfFile;
	QTextStream		m_qtsStream;
};

#endif
