// AdjustThreadController.cpp: Implementierung der Klasse MotorThreadController.
//
//////////////////////////////////////////////////////////////////////

#include "adjustthreadcontroller.h"
#include "adjustthread.h"
#include "amcmirrorpanel.h"
#include <qthread.h>

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

AdjustThreadController::AdjustThreadController( QList<AMCMirrorPanel>& p_qlPanels, QObject* p_pReceiver )
	: ThreadController( p_qlPanels, p_pReceiver )
{
}

AdjustThreadController::~AdjustThreadController()
{

}

void AdjustThreadController::run()
{
	for( AMCMirrorPanel* pActualPanel = m_qlPanels.first();
		 pActualPanel; pActualPanel = m_qlPanels.next() )
	{
		if( m_zStop )
			return;
		AdjustThread* pThread = new AdjustThread( m_pReceiver );
		pThread->setPanel( pActualPanel );
		pThread->setLaser( m_zTrue );
		pThread->start();
		pThread->wait();
		delete pThread;
	}

	return;
}
