/***************************************************************************
                          amcerror.cpp  -  description
                             -------------------
    begin                : Sun Nov 24 2002
    copyright            : (C) 2002 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.					   *
 ***************************************************************************/

#include <qstring.h>
#include <qdatetime.h>
#include <qregexp.h>
#include "amcerror.h"

AMCError::AMCError( const char* p_sError, int p_iDriver ) : m_iDriver(p_iDriver)
{
	m_time = QDateTime::currentDateTime();
	setErrorText( p_sError );
}

AMCError::~AMCError(){
}

/** Set the number of the driver generating the error */
void AMCError::setDriver( int p_iDriver )
{
	m_iDriver = p_iDriver;
}

/** Set the text describing the error condition. */
void AMCError::setErrorText( const char* p_sError )
{
	m_sError = QString::fromLocal8Bit( p_sError );
}

/** Return a reference to the string describing the error. */
const QString& AMCError::getErrorText() const
{
	return m_sError;
}

/** No descriptions */
QString AMCError::formatError( int iNumSpace ) const
{
	// Generate a string containing the given numer of spaces
	// for formating the message.
	QString	spaceString;
	spaceString.fill( QChar( ' ' ), iNumSpace);
	
	QString sResult;
	sResult += spaceString + m_sError + "\n";
	if( !m_sCommand.isEmpty() )
		sResult += spaceString + "Command:  " + QString( m_sCommand ).replace( QRegExp("/010"), "" );
	if( !m_sResponse.isEmpty() )
	{
		sResult += spaceString + " Response: " + QString( m_sResponse ).replace( QRegExp("/010"), "" );
		QString qsTemp;
		for( int i=0; i< m_sResponse.length(); i++)
			sResult += qsTemp.sprintf(" %02X",(unsigned char) m_sResponse[i]);
	}
	sResult += "\n";
	
	return sResult;
}
