/***************************************************************************
                          amcstate.cpp  -  description
                             -------------------
    begin                : Fri Apr 4 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "amcstate.h"

AMCState::AMCState(QObject *parent, const char *name ) : QObject( parent, name )
{
	m_qsStateTxtTable[AMC_STATE_ERROR]         = new QString( "AMC error" );
	m_qsStateTxtTable[AMC_STATE_PARKED]        = new QString( "AMC mirrors parked" );
	m_qsStateTxtTable[AMC_STATE_INITIALIZED]   = new QString( "AMC is initialized" );
	m_qsStateTxtTable[AMC_STATE_READJUST]      = new QString( "AMC neads readjustment" );
	m_qsStateTxtTable[AMC_STATE_ADJUSTED]      = new QString( "AMC is adjusted" );
	m_qsStateTxtTable[AMC_STATE_MOVING]        = new QString( "AMC is moving mirrors" );
	m_qsStateTxtTable[AMC_STATE_LASERADJUSTED] = new QString( "AMC is laser-adjusted" );
	m_qsStateTxtTable[AMC_STATE_UNDEFINED]     = new QString( "AMC is in undefined state" );
	m_qsStateTxtTable[AMC_STATE_USER]          = new QString( "AMC is in user mode" );
	m_qsStateTxtTable[AMC_STATE_NOT_AVAILABLE] = new QString( "AMC has no connection to CC" );
	m_qsStateTxtTable[AMC_STATE_UNKNOWN]			 = new QString( "AMC is in an unknown state." );
	m_iInstalledPanels = 0;
	m_iErrorPanels = 0;
}

AMCState::~AMCState()
{
}

/** Set the state. */
void AMCState::setState( int p_iState )
{
  // if the new state is equal to the actual state we
  // do nothing.
	if( p_iState == m_iState )
		return;

	int iOldState = m_iState;
	m_iState = p_iState;

	emit stateChanged( iOldState, m_iState );
}

/** Return the actual state. */
int AMCState::getState() const
{
	return m_iState;
}

/** Get a textual description of the state. */
const QString& AMCState::getText( int p_iState ) const
{
	if ( ( p_iState < AMC_STATE_ERROR )
				||
			 ( p_iState > AMC_STATE_NOT_AVAILABLE ) )
		return( *m_qsStateTxtTable[ AMC_STATE_UNKNOWN ] );
	else
		return( *m_qsStateTxtTable[ p_iState ] );
}
