/***************************************************************************
                          main.c  -  description
                             -------------------
    begin                : Sat Jul 31 20:10:01 UTC 2004
    copyright            : (C) 2004 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define D_RQ	980.0     // distance to Roque Lamp
#define D_M		17.0			// distance to mirror
#define D_WC	0.035			// distance from focusing plane to winston cones
//#define SQR(x)		((x) * (x))
#define SQR(x)		pow((x),2)


int main(int argc, char *argv[])
{
	int i,j;
	double dx;
	double dy;
	double h, lk, dk, dk2;
	double dLatusRectum;
  double fRq;
	double alpha;
	double delta;
	double deltaF;

	double corr1;
	double corr2;

  for( i = -8; i <= 8; i++)
	  for( j = -8; j <= 8; j++)
		{
			dx = (double) i;
			dy = (double) j;
			h = sqrt( SQR(dx) + SQR(dy));
			if( h < 0.01 )
			{
				dk = 0;
				fRq = D_M;
			}
			else
			{
				dLatusRectum = 4. * D_M;
				dk = ( dLatusRectum - sqrt( SQR( dLatusRectum ) - 8. * SQR( h ) )) / 4.0;
				dk2 = SQR( h ) / dLatusRectum;

				lk = sqrt( SQR( D_M - dk) + SQR(h) );

				alpha = asin( h / lk );
				delta = atan( h / (D_RQ - dk) );
    	  fRq = h / tan( alpha - delta) + dk;
				deltaF =  fRq - D_M;
			}
			printf( "i: %2d j: %2d     ", i, j );
			printf( "h: %f  dk: %f %f ", h, dk, dk2 );
			printf( "  F:  %f   %f", fRq, deltaF );

			corr1 = -h / (fRq - dk) * (deltaF - 0.3);
			corr2 = -h / (fRq - dk) * D_WC;
			printf( "  C:  %5.3f   %f\n", corr1*100., corr2*100. );
		}

  return EXIT_SUCCESS;
}
