/***************************************************************************
                          heatstate.h  -  description
                             -------------------
    begin                : Sat Aug 23 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HEATSTATE_H
#define HEATSTATE_H

#include <qwidget.h>

#define HEAT_STATE_ERROR		      	       0
#define HEAT_STATE_OFF  	                 1
#define HEAT_STATE_ON                		   3
#define HEAT_STATE_DEICING                 4
#define HEAT_STATE_NOT_AVAILABLE           9
#define HEAT_STATE_UNKNOWN								10

/**
  *@author Martin Merck
  */

class HEATState : public QWidget  {
   Q_OBJECT
public: 
	HEATState(QWidget *parent=0, const char *name=0);
	~HEATState();
  /** Return the actual state. */
  int getState() const;
  /** Set the state. */
  void setState( int p_iState );
  /** Get a textual description of the state. */
  const QString& getText( int p_iState ) const;

private: // Private attributes
  /** Variable holding the actual state. */
  int m_iState;
  /**  */
  QString* m_qsStateTxtTable[11];

signals: // Signals
  /** Signal emitted when the state changes. */
  void stateChanged( int p_iOldState, int p_iNewState );
};

#endif
