/***************************************************************************
                          amcprogdlg.h  -  description
                             -------------------
    begin                : Sun Apr 6 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMCPROGDLG_H
#define AMCPROGDLG_H

#include "amcprogdlgbase.h"
#include <qwidget.h>
#include <qthread.h>

/**
  *@author Martin Merck
  */
class QFile;
class QTextStream;
class ThreadController;

class AMCProgDlg : public AMCProgDlgBase, public QThread
{
   Q_OBJECT

public: 
	AMCProgDlg(int p_iType, QWidget *parent=0, const char *name=0, bool modal = FALSE);
	~AMCProgDlg();
	
	void setText( const QString& p_qsText );
	void setBool( bool p_zTrue ) { m_zTrue = p_zTrue; };
	void setParallel( bool p_zParallel ) { m_zParallel = p_zParallel; };
	void customEvent( QCustomEvent* e );

protected:
	virtual void run();

private:
	int		m_iType;
	int		m_iNumErrors;
  int		m_arrErrors[17][17];
  int		m_portErrors[8];
  QFile*	m_pFile;
  QTextStream* m_pStream;
	ThreadController* m_pTController[8];
	bool	m_zTrue;        // Flag used by the controller to pass to worker threads
												// Used to indicate if lasers should be turned on or off
												// or if we should defocus or focus the mirror.
	bool	m_zParallel;		// Flag nidicating if we should process panels in parallel (default true)
protected slots: // Protected slots
  /** No descriptions */
  void reject();
};

#endif
