// amcreportsocket.h: Schnittstelle fr die Klasse ReportController.
//
//////////////////////////////////////////////////////////////////////

#ifndef AMCREPORTSOCKET_H
#define AMCREPORTSOCKET_H

#include <qobject.h>
#include <qdatetime.h>

class ActiveMirrorControl;
class QSocket;
class QTimer;

class AMCReportSocket : public QObject
{
    Q_OBJECT

public:
	AMCReportSocket( QObject* parent );
	virtual ~AMCReportSocket();

public:
	void connectToHost( const QString& m_qsHost, Q_UINT16 m_iPort );
  void setComStatus( int p_iStatus ) { m_iComStatus = p_iStatus; }

private slots:
	void hostFound();
	void connected();
	void connectionClosed();
	void delayedCloseFinished();
	void readyRead();
	void bytesWritten( int p_iNum );
	void error( int p_iErrno );
	void sendReport();

private:
	int m_iComStatus;
	bool m_zConnected;
	QSocket* m_pReportSocket;
	QTimer* m_pSecTimer;
	QDateTime m_qtComTime;
	ActiveMirrorControl*	m_pParent;

signals: // Signals
  /** No descriptions */
  void ccConnectionRefused();
  void ccConnected();
  void reportDelivered( QDateTime&, QString& );
};

#endif
