// errortestthread.h: Schnittstelle fr die Klasse ErrorTestThread.
//
//////////////////////////////////////////////////////////////////////

#ifndef ERRORTESTTHREAD_H
#define ERRORTESTTHREAD_H


#include <qthread.h>
#include <qlist.h>

class AMCMirrorPanel;
class	VideoSpot;


class ErrorTestThread : public QThread
{

public:
	ErrorTestThread( QObject* p_pReceiver );
	virtual ~ErrorTestThread();

	void setPanel( AMCMirrorPanel* p_pPanel );
	void setLaser( bool p_zOn ) { m_zOn = p_zOn; };
	void setData( uchar* p_pData ) { m_pData = p_pData; };
	AMCMirrorPanel* getPanel() { return m_pPanel; };

protected:
	virtual void run();
private:
	AMCMirrorPanel* 	m_pPanel;
	QObject*					m_pReceiver;
	uchar*						m_pData;
	bool							m_zOn;
};

#endif
