/*  Copyright (C) 2001 Marc Casaldaliga Albisu <casaldaliga@ifae.es>
================================================================
 
  This code is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This code is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with Emacs (which is required to make this stuff work); if
  not, write to the Free Software Foundation, Inc., 675 Mass Ave,
  Cambridge, MA 02139, USA.
==================================================================
*/ 

#include "PeriodicAction.H"
//for signals
#include <sigc++/signal_system.h>
using namespace SigC;
PeriodicAction::PeriodicAction( unsigned int period_)
            : period(period_),periodic(period_)
        {
        }
    
            
PeriodicAction::PeriodicAction ( unsigned int period_, const Slot0<bool> & doWhileData, const Slot0<void> & finallyData ) 
            : period(period_), periodic(period_) 
        {

            this->DoWhile(doWhileData);
            this->FinallyDo(finallyData);
        }
    
void PeriodicAction::DoWhileNot( const Slot0<bool> & s)
        {
//              if( doWhileNot || doWhile){
//                      //doWhile actions were defined before, redefining them
//                  if(doWhileNot) delete doWhileNot;
//                  else delete doWhile;
//                  actionConn.disconnect();
                
//              }else{ 
                actionConn=doWhileNot.connect(s);
//            }
            
            periodConn=periodic.signal.connect(slot(this,&PeriodicAction::DoItOnceAndCheckContinuance_Not));
        }
    void PeriodicAction::DoWhile(const Slot0<bool> &s)
        {
//              if( doWhileNot || doWhile){
//                      //doWhile actions were defined before, redefining them
//                  if(doWhileNot) delete doWhileNot;
//                  else delete doWhile;
//                  actionConn.disconnect();
                
//              }else{ 
                actionConn=doWhile.connect(s);
//            }
            
            periodConn=periodic.signal.connect(slot(this,&PeriodicAction::DoItOnceAndCheckContinuance));
        }
    void PeriodicAction::FinallyDo( const Slot0<void> & s)
        {
            finally.connect(s);
        }
    
    void PeriodicAction::DoItOnceAndCheckContinuance() 
        {
            if ( ! doWhile.emit() ){
                periodic.Stop();
                finally.emit();
            }
        }
    void PeriodicAction::DoItOnceAndCheckContinuance_Not() 
        {
            if ( doWhileNot.emit() ){
                periodic.Stop();
                finally.emit();
            }
        }
    

                
//      public method isRunning { } {
//          if { "$scheduledId" == "" } {
//              return 0
//          } else {
//              return 1
//          }
//      }

    void PeriodicAction::Start () {
  //        if(! periodic.isRunning ){
        periodic.Start();
  //        }
            //we don't want to launch it twice
    };
    

    void PeriodicAction::Stop () {
//        if(! periodic.isRunning ){
            periodic.Stop();
//        }
      };
    

//      public method SetPeriod { period_ } {
//          set period $period_
//      }

    




